/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.filter;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.filter.InputOutputFilter;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.util.ClassUtil;

public class FilterManager {
    private InputOutputFilter[] _filters;
    public static final Logger _logger = Logger.getLogger(FilterManager.class);
    private static FilterManager _instance = null;

    public static final synchronized FilterManager getInstance() {
        if (_instance == null) {
            _instance = new FilterManager();
        }
        return _instance;
    }

    public Message doOutputWork(Message msg, Map<String, Object> params) throws CourierException {
        if (this._filters == null || msg == null) {
            return msg;
        }
        for (int i = 0; i < this._filters.length; ++i) {
            if (this._filters[i] == null) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("FilterManager calling " + this._filters[i] + ".onOutput"));
            }
            msg = this._filters[i].onOutput(msg, params);
        }
        return msg;
    }

    public Message doInputWork(Message msg, Map<String, Object> params) throws CourierException {
        if (this._filters == null || msg == null) {
            return msg;
        }
        for (int i = 0; i < this._filters.length; ++i) {
            if (this._filters[i] == null) continue;
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)("FilterManager calling " + this._filters[i] + ".onInput"));
            }
            msg = this._filters[i].onInput(msg, params);
        }
        return msg;
    }

    private FilterManager() {
        PropertyManager pm = ModulePropertyManager.getPropertyManager("filters");
        Properties props = pm.getProperties();
        if (props != null) {
            Enumeration<?> names = props.propertyNames();
            TreeMap<Integer, String> map = new TreeMap<Integer, String>();
            while (names.hasMoreElements()) {
                Integer value;
                String attrName = (String)names.nextElement();
                if (!attrName.startsWith("org.jboss.soa.esb.filter")) continue;
                String order = attrName.substring("org.jboss.soa.esb.filter".length() + 1);
                try {
                    value = new Integer(order);
                }
                catch (NumberFormatException ex) {
                    throw new RuntimeException("Filter name " + order + " is invalid!");
                }
                map.put(value, props.getProperty(attrName));
            }
            if (map.size() > 0) {
                Collection ordered = map.values();
                Iterator iter = ordered.iterator();
                int index = 0;
                this._filters = new InputOutputFilter[map.size()];
                while (iter.hasNext()) {
                    String filterName = (String)iter.next();
                    try {
                        Class c = ClassUtil.forName(filterName, this.getClass());
                        InputOutputFilter theFilter = (InputOutputFilter)c.newInstance();
                        this._filters[index++] = theFilter;
                    }
                    catch (ClassNotFoundException ex) {
                        _logger.warn((Object)("FilterManager problem loading class " + filterName), (Throwable)ex);
                    }
                    catch (Throwable ex) {
                        _logger.warn((Object)("FilterManager problem during load " + filterName), ex);
                    }
                }
            }
        }
    }
}

