/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.couriers;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.URI;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;
import org.jboss.soa.esb.couriers.CourierException;
import org.jboss.soa.esb.message.Message;

public class FaultMessageException
extends CourierException {
    private static final Logger LOGGER = Logger.getLogger(FaultMessageException.class);
    private static final long serialVersionUID = 1L;
    private URI _code;
    private transient Message _msg;
    private transient boolean attemptedDeserialisation;
    private byte[] serialisedForm;

    public FaultMessageException(String message, URI code, Message msg) {
        super(message);
        this._code = code;
        this._msg = msg;
    }

    public FaultMessageException(String message, URI code, Message msg, Throwable cause) {
        super(message, cause);
        this._code = code;
        this._msg = msg;
    }

    public final URI getCode() {
        return this._code;
    }

    public final Message getReturnedMessage() {
        if (this._msg == null && !this.attemptedDeserialisation) {
            this.attemptedDeserialisation = true;
            try {
                this._msg = MessageSerializer.deserialize(this.serialisedForm);
            }
            catch (IOException ioe) {
                LOGGER.warn((Object)"Failed to deserialize fault message", (Throwable)ioe);
            }
        }
        return this._msg;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        if (this._msg != null) {
            this.serialisedForm = MessageSerializer.serialize(this._msg);
        }
        stream.defaultWriteObject();
    }
}

