/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common;

import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.xa.XAResource;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.common.JBossESBTransactionServiceMBean;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.TransactionManagerLocator;

public class JBossESBTransactionService
extends ServiceMBeanSupport
implements JBossESBTransactionServiceMBean {
    protected void createService() throws Exception {
        TransactionStrategy.setTransactionStrategy(new JTATransactionStrategy());
    }

    private static class JTATransactionStrategy
    extends TransactionStrategy {
        private static final Logger LOGGER = Logger.getLogger(JTATransactionStrategy.class);
        private final TransactionManager tm = TransactionManagerLocator.getInstance().locate();

        JTATransactionStrategy() {
        }

        @Override
        public void begin() throws TransactionStrategyException {
            try {
                this.tm.begin();
                LOGGER.trace((Object)"Transaction started on current thread");
            }
            catch (Throwable th) {
                LOGGER.debug((Object)"Failed to start transaction on current thread", th);
                throw new TransactionStrategyException("Failed to begin transaction on current thread", th);
            }
        }

        @Override
        public void terminate() throws TransactionStrategyException {
            try {
                int status = this.tm.getStatus();
                switch (status) {
                    case 0: {
                        LOGGER.trace((Object)"Committing transaction on current thread");
                        this.tm.commit();
                        break;
                    }
                    case 1: {
                        LOGGER.trace((Object)"Rollback transaction on current thread");
                        this.tm.rollback();
                        break;
                    }
                    default: {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace((Object)("Suspending transaction on current thread, status: " + status));
                        }
                        this.tm.suspend();
                        break;
                    }
                }
            }
            catch (Throwable th) {
                LOGGER.debug((Object)"Failed to terminate transaction on current thread", th);
                throw new TransactionStrategyException("Failed to terminate transaction on current thread", th);
            }
        }

        @Override
        public void rollbackOnly() throws TransactionStrategyException {
            try {
                this.tm.setRollbackOnly();
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Failed to mark the transaction on current thread for rollback", th);
            }
        }

        @Override
        public Object getTransaction() throws TransactionStrategyException {
            try {
                return this.tm.getTransaction();
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to getTransaction: ", th);
            }
        }

        @Override
        public Object suspend() throws TransactionStrategyException {
            try {
                return this.tm.suspend();
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to suspend transaction: ", th);
            }
        }

        @Override
        public void resume(Object tx) throws TransactionStrategyException {
            try {
                this.tm.resume((Transaction)tx);
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to resume transaction: ", th);
            }
        }

        @Override
        public void registerSynchronization(Synchronization sync) throws TransactionStrategyException {
            try {
                this.tm.getTransaction().registerSynchronization(sync);
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when registering synchronization: ", th);
            }
        }

        @Override
        public void enlistResource(XAResource resource) throws TransactionStrategyException {
            try {
                this.tm.getTransaction().enlistResource(resource);
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when enlisting resource", th);
            }
        }

        @Override
        public boolean isActive() throws TransactionStrategyException {
            try {
                return this.tm.getStatus() == 0;
            }
            catch (Throwable th) {
                throw new TransactionStrategyException("Problem when trying to get transaction status: ", th);
            }
        }

        public String toString() {
            return "JTATransactionStrategy";
        }
    }
}

