/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.common.JBossESBPropertyServiceMBean;
import org.jboss.system.ServiceMBeanSupport;

public class JBossESBPropertyService
extends ServiceMBeanSupport
implements JBossESBPropertyServiceMBean {
    private static final String ESB_PROPERTY_FILE = "jbossesb-properties.xml";
    private String propertyFile;
    private String propertiesFileDir;

    @Override
    public String getPropertyFile() {
        return this.propertyFile;
    }

    @Override
    public void setPropertyFile(String propertyFile) {
        this.propertyFile = propertyFile;
    }

    @Deprecated
    public static String getBindAddress() {
        return Configuration.getBindAddress();
    }

    private static String fixRemoteAddress(String address) {
        try {
            if (address == null || "0.0.0.0".equals(address)) {
                return InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createService() throws Exception {
        String esbBindAddress = System.getProperty("jboss.esb.bind.address");
        if (esbBindAddress == null) {
            String serverBindAddress = System.getProperty("jboss.bind.address");
            esbBindAddress = JBossESBPropertyService.fixRemoteAddress(serverBindAddress);
            System.setProperty("jboss.esb.bind.address", esbBindAddress);
        }
        if (this.propertyFile != null) {
            InputStream xmlPropertyIS;
            File baseFile = new File(this.propertyFile);
            if (!baseFile.isAbsolute()) {
                URL resourceURL = Thread.currentThread().getContextClassLoader().getResource(this.propertyFile);
                xmlPropertyIS = resourceURL.openStream();
            } else {
                xmlPropertyIS = new FileInputStream(baseFile);
            }
            try {
                if (this.propertiesFileDir == null) {
                    String errorMsg = String.format("No property named '%s' was configured in jbossesb.sar/META-INF/jboss-service.xml for %s", "propertiesFileDir", this.getClass().getName());
                    throw new IllegalArgumentException(errorMsg);
                }
                File dataDir = new File(this.propertiesFileDir);
                if (!dataDir.exists()) {
                    String errorMsg = String.format("The directory configured for %s='%s' does not exist.", "warFilesDir", dataDir);
                    throw new FileNotFoundException(errorMsg);
                }
                File esbPropertyFile = new File(dataDir, ESB_PROPERTY_FILE);
                FileOutputStream esbPropertyOS = new FileOutputStream(esbPropertyFile);
                try {
                    XMLHelper.replaceSystemProperties(XMLHelper.getXMLStreamReader(xmlPropertyIS), XMLHelper.getXMLStreamWriter(esbPropertyOS));
                }
                finally {
                    esbPropertyOS.close();
                }
                System.setProperty("org.jboss.soa.esb.propertyFile", "abs://" + esbPropertyFile.getAbsolutePath());
            }
            finally {
                xmlPropertyIS.close();
            }
        }
    }

    @Override
    public void setPropertiesFileDir(String directory) {
        this.propertiesFileDir = directory;
    }
}

