/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.client;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.actions.AggregationDetails;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.services.registry.RegistryException;

public class MessageMulticaster {
    private static Logger logger = Logger.getLogger(MessageMulticaster.class);
    private Map<Service, ServiceInvoker> invokers = new LinkedHashMap<Service, ServiceInvoker>();
    private String splitId;

    public MessageMulticaster() {
    }

    public MessageMulticaster(String splitId) {
        AssertArgument.isNotNullAndNotEmpty(splitId, "splitId");
        this.splitId = splitId;
    }

    public void addRecipient(Service service) throws RegistryException, MessageDeliverException {
        AssertArgument.isNotNull(service, "service");
        this.invokers.put(service, null);
    }

    public boolean isRecipient(Service service) {
        return this.invokers.containsKey(service);
    }

    public int getRecipientCount() {
        return this.invokers.size();
    }

    public void sendToAll(Message message) throws RegistryException, MessageDeliverException {
        this.sendToSubset(message, new ArrayList<Service>(this.invokers.keySet()));
    }

    public void sendToSubset(Message message, List<Service> recipients) throws RegistryException, MessageDeliverException {
        if (recipients.isEmpty()) {
            logger.warn((Object)"MessageMulticaster.sendToSubset: empty recipients list!");
        } else {
            String seriesUUID = UUID.randomUUID().toString();
            long seriesTimestamp = System.currentTimeMillis();
            int recipientCount = recipients.size();
            for (int i = 0; i < recipientCount; ++i) {
                Service recipient = recipients.get(i);
                ServiceInvoker invoker = this.getInvoker(recipient);
                if (recipientCount > 1) {
                    this.addAggregationDetails(message, seriesUUID, recipientCount, seriesTimestamp, i + 1);
                }
                if (invoker == null) {
                    logger.error((Object)("Service '" + recipient + "' is not in recipient list.  Delivering message to Dead Letter Channel."));
                    ServiceInvoker.deliverToDeadLetterService(message);
                    continue;
                }
                try {
                    invoker.deliverAsync(message);
                    continue;
                }
                catch (MessageDeliverException e) {
                    logger.error((Object)("Failed to deliver message to Service '" + recipient + "'.  Delivering message to Dead Letter Channel."));
                    ServiceInvoker.deliverToDeadLetterService(message);
                }
            }
        }
    }

    private void addAggregationDetails(Message message, String uuId, int recipientCount, long seriesTimestamp, int messageIndex) {
        AggregationDetails aggrDetails = new AggregationDetails(uuId, messageIndex, recipientCount, seriesTimestamp);
        ArrayList<String> aggregatorTags = (ArrayList<String>)message.getProperties().getProperty("aggregatorTag");
        aggrDetails.setSplitId(this.splitId);
        if (aggregatorTags == null) {
            aggregatorTags = new ArrayList<String>();
            message.getProperties().setProperty("aggregatorTag", aggregatorTags);
        }
        if (messageIndex > 1) {
            aggregatorTags.remove(aggregatorTags.size() - 1);
        }
        aggregatorTags.add(aggrDetails.toString());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("aggregatorTag=" + aggrDetails));
        }
    }

    private ServiceInvoker getInvoker(Service recipient) throws RegistryException, MessageDeliverException {
        ServiceInvoker invoker = this.invokers.get(recipient);
        if (invoker == null) {
            if (!this.invokers.containsKey(recipient)) {
                return null;
            }
            invoker = new ServiceInvoker(recipient);
            this.invokers.put(recipient, invoker);
        }
        return invoker;
    }
}

