/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JDBCEpr
extends EPR {
    public static final String JDBC_PROTOCOL = "jdbc";
    public static final String DATASOURCE_TAG = "datasource";
    public static final String USERNAME_TAG = "username";
    public static final String PASSWORD_TAG = "password";
    public static final String SQL_TAG = "sql";
    public static final String DRIVER_TAG = "driver";
    public static final String URL_TAG = "URL";
    public static final String TABLE_NAME_TAG = "tablename";
    public static final String ORDER_BY_TAG = "orderBy";
    public static final String MESSAGE_ID_COLUMN_TAG = "message_id_column";
    public static final String STATUS_COLUMN_TAG = "status_column";
    public static final String RETRY_COUNT_COLUMN_TAG = "retry_count_column";
    public static final String DATA_COLUMN_TAG = "message_column";
    public static final String TIMESTAMP_COLUMN_TAG = "insert_timestamp_column";
    public static final String WHERE_CONDITION_TAG = "whereCondition";
    public static final String POST_DEL_TAG = "postDelete";
    public static final String ERROR_DEL_TAG = "errorDelete";
    public static final String DEFAULT_REPLY_TO_TABLE_SUFFIX = "_reply_table";
    private boolean userSet = false;
    private boolean passwordSet = false;
    private boolean sqlSet = false;
    private boolean driverSet = false;
    private boolean tableNameSet = false;
    private boolean messageIdSet = false;
    private boolean retryCountSet = false;
    private boolean statusSet = false;
    private boolean dataSet = false;
    private boolean timestampSet = false;
    private static URI _type;

    public JDBCEpr(EPR epr) {
        super(epr);
        if (epr instanceof JDBCEpr) {
            JDBCEpr instance = (JDBCEpr)epr;
            this.userSet = instance.userSet;
            this.passwordSet = instance.passwordSet;
            this.sqlSet = instance.sqlSet;
            this.driverSet = instance.driverSet;
            this.tableNameSet = instance.tableNameSet;
            this.messageIdSet = instance.messageIdSet;
            this.statusSet = instance.statusSet;
            this.dataSet = instance.dataSet;
            this.timestampSet = instance.timestampSet;
        }
    }

    public JDBCEpr(EPR epr, Element header) {
        super(epr);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                String prefix = nl.item(i).getPrefix();
                String tag = nl.item(i).getLocalName();
                if (prefix == null || !prefix.equals("jbossesb") || tag == null) continue;
                if (tag.equals(USERNAME_TAG)) {
                    this.setUserName(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(PASSWORD_TAG)) {
                    this.setPassword(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(SQL_TAG)) {
                    this.setSQL(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(DRIVER_TAG)) {
                    this.setDriver(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(URL_TAG)) {
                    this.setURL(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(TABLE_NAME_TAG)) {
                    this.setTableName(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(MESSAGE_ID_COLUMN_TAG)) {
                    this.setMessageIdColumn(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(STATUS_COLUMN_TAG)) {
                    this.setStatusColumn(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(DATA_COLUMN_TAG)) {
                    this.setDataColumn(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(TIMESTAMP_COLUMN_TAG)) {
                    this.setTimestampColumn(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(POST_DEL_TAG)) {
                    this.getAddr().addExtension(POST_DEL_TAG, nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(ERROR_DEL_TAG)) {
                    this.getAddr().addExtension(ERROR_DEL_TAG, nl.item(i).getTextContent());
                    continue;
                }
                if (!tag.equals(RETRY_COUNT_COLUMN_TAG)) continue;
                this.setRetryCountColumn(nl.item(i).getTextContent());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public JDBCEpr(String url, String sql) throws URISyntaxException {
        super(new URI(url));
        this.setSQL(sql);
    }

    public JDBCEpr(String url) throws URISyntaxException {
        this(url, true, true);
    }

    public JDBCEpr(String url, boolean postDelete, boolean errorDelete) throws URISyntaxException {
        super(new URI(url));
        if (postDelete) {
            this.getAddr().addExtension(POST_DEL_TAG, Boolean.toString(postDelete));
        }
        if (errorDelete) {
            this.getAddr().addExtension(ERROR_DEL_TAG, Boolean.toString(errorDelete));
        }
    }

    @Override
    public EPR copy() {
        return new JDBCEpr(this);
    }

    public final void setURL(String url) {
        super.setAddr(new PortReference(url));
    }

    public final String getURL() {
        return this.getAddr().getAddress();
    }

    public final void setUserName(String username) throws URISyntaxException {
        if (username == null) {
            throw new IllegalArgumentException();
        }
        if (this.userSet) {
            throw new IllegalStateException("Username already set.");
        }
        this.getAddr().addExtension(USERNAME_TAG, username);
        this.userSet = true;
    }

    public final String getUserName() {
        return this.getAddr().getExtensionValue(USERNAME_TAG);
    }

    public final void setPassword(String password) throws URISyntaxException {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        if (this.passwordSet) {
            throw new IllegalStateException("Password already set.");
        }
        this.getAddr().addExtension(PASSWORD_TAG, password);
        this.passwordSet = true;
    }

    public final String getPassword() {
        return this.getAddr().getExtensionValue(PASSWORD_TAG);
    }

    public final void setDatasource(String datasource) {
        this.getAddr().addExtension(DATASOURCE_TAG, datasource);
    }

    public final String getDatasource() {
        return this.getAddr().getExtensionValue(DATASOURCE_TAG);
    }

    public final void setSQL(String sql) throws URISyntaxException {
        if (sql == null) {
            throw new IllegalArgumentException();
        }
        if (this.sqlSet) {
            throw new IllegalStateException("SQL already set.");
        }
        this.getAddr().addExtension(SQL_TAG, sql);
        this.sqlSet = true;
    }

    public final String getSQL() {
        return this.getAddr().getExtensionValue(SQL_TAG);
    }

    public final void setDriver(String driver) throws URISyntaxException {
        if (driver == null) {
            throw new IllegalArgumentException();
        }
        if (this.driverSet) {
            throw new IllegalStateException("Driver already set.");
        }
        this.getAddr().addExtension(DRIVER_TAG, driver);
        this.driverSet = true;
    }

    public final String getDriver() {
        return this.getAddr().getExtensionValue(DRIVER_TAG);
    }

    public final void setTableName(String tableName) throws URISyntaxException {
        if (tableName == null) {
            throw new IllegalArgumentException();
        }
        if (this.tableNameSet) {
            throw new IllegalStateException("Table name already set.");
        }
        this.getAddr().addExtension(TABLE_NAME_TAG, tableName);
        this.tableNameSet = true;
    }

    public final String getTableName() {
        return this.getAddr().getExtensionValue(TABLE_NAME_TAG);
    }

    public final void setMessageIdColumn(String columnName) throws URISyntaxException {
        if (columnName == null) {
            throw new IllegalArgumentException();
        }
        if (this.messageIdSet) {
            throw new IllegalStateException("Message Id column already set.");
        }
        this.getAddr().addExtension(MESSAGE_ID_COLUMN_TAG, columnName);
        this.messageIdSet = true;
    }

    public final String getMessageIdColumn() {
        return this.getAddr().getExtensionValue(MESSAGE_ID_COLUMN_TAG);
    }

    public final void setRetryCountColumn(String columnName) throws URISyntaxException {
        if (columnName == null) {
            return;
        }
        if (this.retryCountSet) {
            throw new IllegalStateException("Retry Count column already set.");
        }
        this.getAddr().addExtension(RETRY_COUNT_COLUMN_TAG, columnName);
        this.retryCountSet = true;
    }

    public final String getRetryCountColumn() {
        return this.getAddr().getExtensionValue(RETRY_COUNT_COLUMN_TAG);
    }

    public final void setStatusColumn(String statusColumn) throws URISyntaxException {
        if (statusColumn == null) {
            throw new IllegalArgumentException();
        }
        if (this.statusSet) {
            throw new IllegalStateException("Status column already set.");
        }
        this.getAddr().addExtension(STATUS_COLUMN_TAG, statusColumn);
        this.statusSet = true;
    }

    public final String getStatusColumn() {
        return this.getAddr().getExtensionValue(STATUS_COLUMN_TAG);
    }

    public final void setDataColumn(String dataColumn) throws URISyntaxException {
        if (dataColumn == null) {
            throw new IllegalArgumentException();
        }
        if (this.dataSet) {
            throw new IllegalStateException("Data column already set.");
        }
        this.getAddr().addExtension(DATA_COLUMN_TAG, dataColumn);
        this.dataSet = true;
    }

    public final String getDataColumn() {
        return this.getAddr().getExtensionValue(DATA_COLUMN_TAG);
    }

    public final void setTimestampColumn(String timeColumn) throws URISyntaxException {
        if (timeColumn == null) {
            throw new IllegalArgumentException();
        }
        if (this.timestampSet) {
            throw new IllegalStateException("Timestamp column already set.");
        }
        this.getAddr().addExtension(TIMESTAMP_COLUMN_TAG, timeColumn);
        this.timestampSet = true;
    }

    public final String getTimestampColumn() {
        return this.getAddr().getExtensionValue(TIMESTAMP_COLUMN_TAG);
    }

    public final String getPostDelete() {
        return this.getAddr().getExtensionValue(POST_DEL_TAG);
    }

    public final String getErrorDelete() {
        return this.getAddr().getExtensionValue(ERROR_DEL_TAG);
    }

    @Override
    public String toString() {
        return "JDBCEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    public static final URI type() {
        return _type;
    }

    protected final void changeTableName(String tableName) throws URISyntaxException {
        this.tableNameSet = false;
        super.getAddr().removeExtension(TABLE_NAME_TAG, this.getTableName());
        this.setTableName(tableName);
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/jdbc");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

