/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.w3c.dom.Element;

public class HTTPEpr
extends EPR {
    private static URI _type;

    public HTTPEpr(EPR epr) {
        super(epr);
    }

    public HTTPEpr(EPR epr, Element header) {
        super(epr);
    }

    public HTTPEpr(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public HTTPEpr(URI uri) {
        super(uri);
    }

    public HTTPEpr(String url) throws URISyntaxException {
        super(new URI(url));
    }

    public final void setURL(URL url) {
        super.setAddr(new PortReference(url.toString()));
    }

    public final URL getURL() {
        try {
            return new URL(super.getAddr().getAddress());
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    @Override
    public String toString() {
        return "HTTPEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    @Override
    public EPR copy() {
        return new HTTPEpr(this);
    }

    public static final URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/http");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

