/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.jboss.soa.esb.addressing.eprs.FileEpr;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class FTPEpr
extends FileEpr {
    public static final String USERNAME_TAG = "username";
    public static final String PASSWORD_TAG = "password";
    public static final String PASSIVE_TAG = "passive";
    private boolean passwordSet = false;
    private boolean userSet = false;
    private boolean passiveSet = false;
    private static URI _type;

    public FTPEpr(EPR epr) {
        super(epr);
        if (epr instanceof FTPEpr) {
            FTPEpr instance = (FTPEpr)epr;
            this.passwordSet = instance.passwordSet;
            this.userSet = instance.userSet;
            this.passiveSet = instance.passiveSet;
        }
    }

    public FTPEpr(EPR epr, Element header) {
        super(epr, header);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                String prefix = nl.item(i).getPrefix();
                String tag = nl.item(i).getLocalName();
                if (prefix == null || !prefix.equals("jbossesb") || tag == null) continue;
                if (tag.equals(USERNAME_TAG)) {
                    this.setUserName(nl.item(i).getTextContent());
                    continue;
                }
                if (tag.equals(PASSWORD_TAG)) {
                    this.setPassword(nl.item(i).getTextContent());
                    continue;
                }
                if (!tag.equals(PASSIVE_TAG)) continue;
                String content = nl.item(i).getTextContent();
                if ("true".equalsIgnoreCase(content)) {
                    this.setPassive(true);
                    continue;
                }
                if (!"false".equalsIgnoreCase(content)) continue;
                this.setPassive(false);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public FTPEpr(URL url) throws URISyntaxException {
        this(url.toURI());
    }

    public FTPEpr(URI uri) {
        super(uri);
    }

    public FTPEpr(String url) throws URISyntaxException {
        super(new URI(url));
    }

    @Override
    public final void setURL(URL url) {
        super.setAddr(new PortReference(url.toString()));
    }

    @Override
    public final URL getURL() {
        try {
            return new URL(super.getAddr().getAddress());
        }
        catch (Exception ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    public final void setUserName(String username) throws URISyntaxException {
        if (username == null) {
            throw new IllegalArgumentException();
        }
        if (this.userSet) {
            throw new IllegalStateException("Username already set.");
        }
        this.getAddr().addExtension(USERNAME_TAG, username);
        this.userSet = true;
    }

    public final String getUserName() {
        return this.getAddr().getExtensionValue(USERNAME_TAG);
    }

    public final void setPassword(String password) throws URISyntaxException {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        if (this.passwordSet) {
            throw new IllegalStateException("Cannot change password");
        }
        this.getAddr().addExtension(PASSWORD_TAG, password);
        this.passwordSet = true;
    }

    public final String getPassword() {
        return this.getAddr().getExtensionValue(PASSWORD_TAG);
    }

    public final void setPassive(boolean passive) throws URISyntaxException {
        if (this.passiveSet) {
            throw new IllegalStateException("Cannot change passive");
        }
        if (passive) {
            this.getAddr().addExtension(PASSIVE_TAG, "true");
        } else {
            this.getAddr().addExtension(PASSIVE_TAG, "false");
        }
        this.passiveSet = true;
    }

    public final boolean getPassive() {
        return "true".equals(this.getAddr().getExtensionValue(PASSIVE_TAG));
    }

    @Override
    public String toString() {
        return "FTPEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    @Override
    public EPR copy() {
        return new FTPEpr(this);
    }

    public static URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/ftp");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

