/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.addressing.eprs;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.addressing.PortReference;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EmailEpr
extends EPR {
    public static final String DEFAULT_PORT = "25";
    public static final String DEFAULT_USERNAME = "";
    public static final String DEFAULT_PASSWORD = "";
    public static final String SMTP_PROTOCOL = "smtp";
    public static final String POP_PROTOCOL = "pop";
    public static final String USERNAME_TAG = "username";
    public static final String PASSWORD_TAG = "password";
    private static final String PROTOCOL_SEPARATOR = "://";
    private static final String PORT_SEPARATOR = ":";
    private static URI _type;

    public EmailEpr(EPR epr) {
        super(epr);
    }

    public EmailEpr(EPR epr, Element header) {
        super(epr);
        NodeList nl = header.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                String prefix = nl.item(i).getPrefix();
                String tag = nl.item(i).getLocalName();
                if (prefix == null || !prefix.equals("jbossesb")) continue;
                if (tag != null && tag.equals(USERNAME_TAG)) {
                    this.getAddr().addExtension(USERNAME_TAG, nl.item(i).getTextContent());
                    continue;
                }
                if (tag == null || !tag.equals(PASSWORD_TAG)) continue;
                this.getAddr().addExtension(PASSWORD_TAG, nl.item(i).getTextContent());
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public EmailEpr(String protocol, String host) {
        this(protocol, host, DEFAULT_PORT, "", "");
    }

    public EmailEpr(String protocol, String host, String port, String username, String password) {
        PortReference addr;
        if (protocol == null || host == null || port == null) {
            throw new IllegalArgumentException();
        }
        if (protocol.equals(SMTP_PROTOCOL) || protocol.equals(POP_PROTOCOL)) {
            addr = new PortReference(protocol + PROTOCOL_SEPARATOR + host + PORT_SEPARATOR + port);
            if (username != null) {
                addr.addExtension(USERNAME_TAG, username);
            }
            if (password != null) {
                addr.addExtension(PASSWORD_TAG, password);
            }
        } else {
            throw new IllegalArgumentException("Invalid email protocol!");
        }
        this.setAddr(addr);
    }

    public final String getProtocol() {
        try {
            URI addr = new URI(this.getAddr().getAddress());
            return addr.getScheme();
        }
        catch (URISyntaxException ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    public final String getHost() {
        try {
            URI addr = new URI(this.getAddr().getAddress());
            return addr.getHost();
        }
        catch (URISyntaxException ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return null;
        }
    }

    public final int getPort() {
        try {
            URI addr = new URI(this.getAddr().getAddress());
            return addr.getPort();
        }
        catch (URISyntaxException ex) {
            _logger.warn((Object)"Unexpected parsing exception!", (Throwable)ex);
            return -1;
        }
    }

    public final String getPassword() {
        return this.getAddr().getExtensionValue(PASSWORD_TAG);
    }

    public final String getUserName() {
        return this.getAddr().getExtensionValue(USERNAME_TAG);
    }

    @Override
    public String toString() {
        return "EmailEpr [ " + super.getAddr().extendedToString() + " ]";
    }

    @Override
    public EPR copy() {
        return new EmailEpr(this);
    }

    public static final URI type() {
        return _type;
    }

    static {
        try {
            _type = new URI("urn:jboss/esb/epr/type/email");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new ExceptionInInitializerError(ex.toString());
        }
    }
}

