/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.transformation.xslt.ResultFactory;
import org.jboss.soa.esb.actions.transformation.xslt.SourceFactory;
import org.jboss.soa.esb.actions.transformation.xslt.SourceResult;
import org.jboss.soa.esb.actions.transformation.xslt.TransformerFactoryConfig;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.ClassUtil;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XsltAction
extends AbstractActionPipelineProcessor {
    private static Logger log = Logger.getLogger(XsltAction.class);
    private TransformerFactoryConfig transformerConfig;
    private boolean failOnWarning;
    private SAXParserFactory validationFactory;
    private Templates xslTemplate;
    private MessagePayloadProxy payloadProxy;
    private int transformerPoolSize;
    private ArrayBlockingQueue<Transformer> transformers;

    public XsltAction(ConfigTree config) throws ConfigurationException {
        this.transformerConfig = this.createConfig(config);
        this.failOnWarning = config.getBooleanAttribute("failOnWarning", true);
        this.payloadProxy = new MessagePayloadProxy(config);
        this.transformerPoolSize = this.getMaxThreadsFromParentConfigTree(config);
    }

    int getMaxThreadsFromParentConfigTree(ConfigTree config) throws ConfigurationException {
        try {
            ConfigTree parent = config.getParent();
            String maxThreadsStr = parent != null ? parent.getRequiredAttribute("maxThreads") : config.getRequiredAttribute("maxThreads");
            int maxThreads = Integer.parseInt(maxThreadsStr);
            if (maxThreads <= 0) {
                throw new ConfigurationException("maxThreads must be a positive integer. Was [" + maxThreads + "]");
            }
            return maxThreads;
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Could not parse maxThreads to an int.", e);
        }
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        AssertArgument.isNotNull(message, "message");
        try {
            Result result;
            Source source;
            ValidationHandler validationHandler;
            Object payload = this.getPayload(message);
            if (payload instanceof SourceResult) {
                validationHandler = null;
                SourceResult sourceResult = (SourceResult)payload;
                source = sourceResult.getSource();
                result = sourceResult.getResult();
            } else {
                validationHandler = new ValidationHandler(this.failOnWarning);
                source = SourceFactory.getInstance().createSource(payload, this.validationFactory, validationHandler);
                result = ResultFactory.getInstance().createResult(this.transformerConfig.getResultType());
            }
            this.transform(source, result);
            if (validationHandler != null) {
                validationHandler.check();
            }
            Object object = ResultFactory.getInstance().extractResult(result, this.transformerConfig.getResultType());
            return this.setPayload(message, object);
        }
        catch (TransformerConfigurationException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        catch (TransformerException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transform(Source source, Result result) throws TransformerException, ActionProcessingException {
        Transformer transformer = null;
        try {
            transformer = this.transformers.take();
        }
        catch (InterruptedException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        try {
            transformer.transform(source, result);
        }
        finally {
            try {
                transformer.reset();
                this.transformers.put(transformer);
            }
            catch (InterruptedException e) {
                throw new ActionProcessingException(e.getMessage(), e);
            }
        }
    }

    @Override
    public void initialise() throws ActionLifecycleException {
        try {
            TransformerFactory factory = TransformerFactory.newInstance();
            this.addFeatures(this.transformerConfig.getFeatures(), factory);
            this.addAttributes(this.transformerConfig.getAttributes(), factory);
            this.setResolver(this.transformerConfig.getUriResolver(), factory);
            this.setErrorListener(new TransformerListener(this.failOnWarning), factory);
            this.createValidationFactory(factory);
            this.xslTemplate = this.createTemplate(this.transformerConfig.getTemplateFile(), factory);
            this.transformers = new ArrayBlockingQueue(this.transformerPoolSize);
            int i = this.transformerPoolSize;
            while (--i >= 0) {
                this.transformers.add(this.xslTemplate.newTransformer());
            }
        }
        catch (TransformerConfigurationException e) {
            throw new ActionLifecycleException(e.getMessage(), e);
        }
    }

    private void addFeatures(Map<String, Boolean> features, TransformerFactory factory) throws TransformerConfigurationException {
        for (Map.Entry<String, Boolean> entry : features.entrySet()) {
            factory.setFeature(entry.getKey(), entry.getValue());
        }
    }

    private void addAttributes(Map<String, Object> attributes, TransformerFactory factory) throws TransformerConfigurationException {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            factory.setAttribute(entry.getKey(), entry.getValue());
        }
    }

    private void setResolver(URIResolver uriResolver, TransformerFactory factory) {
        if (uriResolver != null) {
            factory.setURIResolver(uriResolver);
        }
    }

    private void setErrorListener(ErrorListener errorListener, TransformerFactory factory) {
        factory.setErrorListener(errorListener);
    }

    private void createValidationFactory(TransformerFactory factory) throws ActionLifecycleException {
        if (factory.getFeature("http://javax.xml.transform.sax.SAXSource/feature")) {
            this.validationFactory = SAXParserFactory.newInstance();
            this.validationFactory.setNamespaceAware(true);
        } else {
            log.warn((Object)"TransformerFactory does not support http://javax.xml.transform.sax.SAXSource/feature");
        }
    }

    private Templates createTemplate(String templateFile, TransformerFactory factory) throws ActionLifecycleException, TransformerConfigurationException {
        InputStream stream = null;
        try {
            stream = StreamUtils.getResource(templateFile);
            Templates templates = factory.newTemplates(new StreamSource(stream));
            return templates;
        }
        catch (ConfigurationException e) {
            throw new ActionLifecycleException(e.getMessage(), e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ignore) {
                    log.error((Object)"Exception while closing stream", (Throwable)ignore);
                }
            }
        }
    }

    private TransformerFactoryConfig createConfig(ConfigTree config) throws ConfigurationException {
        TransformerFactoryConfig.Builder builder = new TransformerFactoryConfig.Builder(config.getRequiredAttribute("templateFile"));
        this.extractFeatures(config, builder);
        this.extractAttributes(config, builder);
        this.createUrlResolver(config, builder);
        builder.resultType(ResultFactory.ResultType.valueOf(config.getRequiredAttribute("resultType")));
        return builder.build();
    }

    void extractAttributes(ConfigTree config, TransformerFactoryConfig.Builder builder) {
        for (String attrName : config.getAttributeNames()) {
            int idx = attrName.indexOf("factory.attribute.");
            if (idx == -1) continue;
            String value = config.getAttribute(attrName);
            String name = attrName.substring(idx + "factory.attribute.".length());
            builder.attribute(name, value);
        }
    }

    void createUrlResolver(ConfigTree config, TransformerFactoryConfig.Builder builder) throws ConfigurationException {
        String className = config.getAttribute("uriResolver");
        if (className != null) {
            try {
                Class resolver = ClassUtil.forName(className, this.getClass());
                URIResolver uriResolver = (URIResolver)resolver.newInstance();
                builder.uriResolver(uriResolver);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            catch (InstantiationException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException(e.getMessage(), e);
            }
        }
    }

    void extractFeatures(ConfigTree config, TransformerFactoryConfig.Builder builder) {
        for (String attrName : config.getAttributeNames()) {
            int idx = attrName.indexOf("factory.feature.");
            if (idx == -1) continue;
            String value = config.getAttribute(attrName);
            String name = attrName.substring(idx + "factory.feature.".length());
            builder.feature(name, Boolean.valueOf(value));
        }
    }

    private Object getPayload(Message message) throws ActionProcessingException {
        try {
            return this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
    }

    private Message setPayload(Message message, Object payload) throws ActionProcessingException {
        try {
            this.payloadProxy.setPayload(message, payload);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e.getMessage(), e);
        }
        return message;
    }

    public TransformerFactoryConfig getTranformerConfig() {
        return this.transformerConfig;
    }

    public String toString() {
        return String.format("%s templateFile=%s, failOnWarning=%b, features=%s, attributes=%s", this.getClass().getSimpleName(), this.transformerConfig.getTemplateFile(), this.failOnWarning, this.transformerConfig.getFeatures(), this.transformerConfig.getAttributes());
    }

    public int getNumberOfPooledTransfomers() {
        if (this.transformers == null) {
            throw new IllegalStateException("The transformers have not been initialized yet. Please make sure that initialize has bee called prior to calling this method.");
        }
        return this.transformers.size();
    }

    private static class ValidationHandler
    implements ErrorHandler {
        private final boolean failOnWarning;
        private SAXParseException exception = null;

        public ValidationHandler(boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }

        private void check() throws SAXParseException {
            if (this.exception != null) {
                throw this.exception;
            }
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            if (this.failOnWarning) {
                this.exception = exception;
                throw exception;
            }
            log.warn((Object)"Validation Warning.", (Throwable)exception);
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            this.exception = exception;
            throw exception;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            this.exception = exception;
            throw exception;
        }
    }

    private static class TransformerListener
    implements ErrorListener {
        private final boolean failOnWarning;

        public TransformerListener(boolean failOnWarning) {
            this.failOnWarning = failOnWarning;
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            if (this.failOnWarning) {
                throw exception;
            }
            log.warn((Object)"Transformation Warning.", (Throwable)exception);
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

