/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.transformation.xslt;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SourceFactory {
    private static final SourceFactory factory = new SourceFactory();

    private SourceFactory() {
    }

    public static SourceFactory getInstance() {
        return factory;
    }

    public Source createSource(Object from) {
        try {
            return this.createSource(from, null, null);
        }
        catch (SAXException e) {
            throw new RuntimeException("Should not occur when not validating XML InputSource!", e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException("Should not occur when not validating XML InputSource!", e);
        }
    }

    public Source createSource(Object from, SAXParserFactory validationFactory, ErrorHandler validationHandler) throws SAXException, ParserConfigurationException {
        Source source;
        XMLReader validationReader;
        if (validationFactory != null) {
            validationReader = validationFactory.newSAXParser().getXMLReader();
            if (validationHandler != null) {
                validationReader.setErrorHandler(validationHandler);
            }
        } else {
            validationReader = null;
        }
        if (from instanceof String) {
            StringReader reader = new StringReader((String)from);
            source = validationReader != null ? new SAXSource(validationReader, new InputSource(reader)) : new StreamSource(reader);
        } else if (from instanceof byte[]) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])from);
            source = validationReader != null ? new SAXSource(validationReader, new InputSource(inputStream)) : new StreamSource(inputStream);
        } else if (from instanceof Reader) {
            Reader reader = (Reader)from;
            source = validationReader != null ? new SAXSource(validationReader, new InputSource(reader)) : new StreamSource(reader);
        } else if (from instanceof InputStream) {
            InputStream inputStream = (InputStream)from;
            source = validationReader != null ? new SAXSource(validationReader, new InputSource(inputStream)) : new StreamSource(inputStream);
        } else if (from instanceof File) {
            BufferedInputStream inputStream;
            try {
                inputStream = new BufferedInputStream(new FileInputStream((File)from));
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            source = validationReader != null ? new SAXSource(validationReader, new InputSource(inputStream)) : new StreamSource(inputStream);
        } else if (from instanceof Source) {
            source = (Source)from;
        } else {
            throw new IllegalStateException("Object '" + from + "' is not of a supported type (String, byte[], Reader, InputStream, File, or Source). Try using a SourceResult instead perhaps.");
        }
        return source;
    }
}

