/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.scripting;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.bsf.BSFException;
import org.apache.bsf.BSFManager;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.ClassUtil;

public class ScriptingAction
extends AbstractActionPipelineProcessor {
    private static Logger logger = Logger.getLogger(ScriptingAction.class);
    private static final Map<String, String> EXTN2LANG = new HashMap<String, String>();
    private ConfigTree config;
    private MessagePayloadProxy payloadProxy;
    private String script;
    private String source;
    private String language;

    public ScriptingAction(ConfigTree config) {
        this.config = config;
        this.payloadProxy = new MessagePayloadProxy(config);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void initialise() throws ActionLifecycleException {
        int pos;
        String source;
        String scriptPath = this.getAttribute("script");
        if (scriptPath == null) {
            boolean supportMessageBasedScripting = this.config.getBooleanAttribute("supportMessageBasedScripting", false);
            if (!supportMessageBasedScripting) throw new ActionLifecycleException("'script' not configured on the action and message based scripting is not enabled ('supportMessageBasedScripting=false').");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No script specified on action config " + this.config.getAttribute("name") + ". Expecting script to be in message."));
            }
            source = "Embedded script in message";
        } else {
            InputStream scriptStream = null;
            try {
                scriptStream = ClassUtil.getResourceAsStream(scriptPath, ScriptingAction.class);
                if (scriptStream == null) throw new ActionLifecycleException("script '" + scriptPath + "' not found on classpath");
                scriptStream = new BufferedInputStream(scriptStream);
                this.script = new String(StreamUtils.readStream(scriptStream));
            }
            catch (Throwable t) {
                throw new ActionLifecycleException(t);
            }
            finally {
                try {
                    if (scriptStream != null) {
                        scriptStream.close();
                    }
                }
                catch (Throwable t) {}
            }
            source = scriptPath;
        }
        this.source = source;
        this.language = this.getAttribute("language");
        if (this.language == null && this.script != null && (pos = scriptPath.lastIndexOf(46)) > -1 && pos < scriptPath.length() - 1) {
            this.language = scriptPath.substring(pos + 1, scriptPath.length()).toLowerCase();
        }
        if (this.language == null) throw new ActionLifecycleException("language not specified");
        if (EXTN2LANG.containsKey(this.language)) {
            this.language = EXTN2LANG.get(this.language);
            return;
        } else {
            if (BSFManager.isLanguageRegistered((String)this.language)) return;
            throw new ActionLifecycleException("language '" + this.language + "' not registered");
        }
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        BSFManager bsf = new BSFManager();
        try {
            bsf.declareBean("message", (Object)message, message.getClass());
            bsf.declareBean("config", (Object)this.config, this.config.getClass());
            bsf.declareBean("payloadProxy", (Object)this.payloadProxy, this.payloadProxy.getClass());
            bsf.declareBean("logger", (Object)logger, logger.getClass());
            bsf.exec(this.language, this.source, 0, 0, (Object)this.getScript(message));
        }
        catch (BSFException bsfe) {
            String error = "Exception caught while processing script: '" + this.source + "'";
            if (logger.isDebugEnabled()) {
                logger.debug((Object)error, (Throwable)bsfe);
            }
            throw new ActionProcessingException(error, bsfe);
        }
        finally {
            bsf.terminate();
        }
        return message;
    }

    private String getScript(Message message) throws ActionProcessingException {
        Object messageScript;
        if (this.script != null) {
            return this.script;
        }
        try {
            messageScript = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException mde) {
            throw new ActionProcessingException(mde);
        }
        if (messageScript instanceof String) {
            return (String)messageScript;
        }
        if (messageScript instanceof byte[]) {
            return new String((byte[])messageScript);
        }
        throw new ActionProcessingException("script not specified in message");
    }

    private String getAttribute(String name) {
        String value = this.config.getAttribute(name);
        if (value != null && (value = value.trim()).length() == 0) {
            value = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        InputStream is = null;
        try {
            is = BSFManager.class.getClassLoader().getResourceAsStream("org/apache/bsf/Languages.properties");
            is = new BufferedInputStream(is);
            Properties props = new Properties();
            props.load(is);
            Enumeration<?> names = props.propertyNames();
            while (names.hasMoreElements()) {
                String lang = (String)names.nextElement();
                StringTokenizer st = new StringTokenizer(props.getProperty(lang), ",");
                st.nextToken();
                st = new StringTokenizer(st.nextToken(), "|");
                while (st.hasMoreTokens()) {
                    EXTN2LANG.put(st.nextToken().trim(), lang);
                }
            }
        }
        catch (IOException ioe) {
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable t) {}
        }
    }
}

