/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.scripting;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import groovy.lang.Script;
import groovy.util.GroovyScriptEngine;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.StreamUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionLifecycleException;
import org.jboss.soa.esb.actions.ActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.ClassUtil;

public class GroovyActionProcessor
implements ActionPipelineProcessor {
    private static Logger logger = Logger.getLogger(GroovyActionProcessor.class);
    protected ConfigTree configTree;
    protected GroovyScriptEngine scriptEngine;
    private String scriptPath;
    private Script script;
    private boolean cacheScript;
    private MessagePayloadProxy payloadProxy;

    public GroovyActionProcessor(ConfigTree config) throws ConfigurationException {
        this.configTree = config;
        this.payloadProxy = new MessagePayloadProxy(this.configTree, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
    }

    @Override
    public void initialise() throws ActionLifecycleException {
        this.scriptPath = this.configTree.getAttribute("script");
        this.cacheScript = this.configTree.getBooleanAttribute("cacheScript", true);
        if (this.scriptPath == null) {
            boolean supportMessageBasedScripting = this.configTree.getBooleanAttribute("supportMessageBasedScripting", false);
            if (supportMessageBasedScripting) {
                logger.info((Object)("No Groovy script specified on action config " + this.configTree.getAttribute("name") + ". Expecting Groovy script to be in message."));
            } else {
                throw new ActionLifecycleException("'script' not configured on the action and message based scripting is not enabled ('supportMessageBasedScripting=false').");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getScriptFromClasspath(String scriptPath) throws IOException {
        InputStream scriptStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(scriptPath);
        if (scriptStream == null && (scriptStream = ClassUtil.getResourceAsStream(scriptPath, GroovyActionProcessor.class)) == null) {
            throw new IOException("Script '" + scriptPath + "' not found on classpath.");
        }
        try {
            String string = new String(StreamUtils.readStream(scriptStream));
            return string;
        }
        finally {
            try {
                if (scriptStream != null) {
                    scriptStream.close();
                }
            }
            catch (IOException e) {
                throw new IOException("Failed to close script '" + scriptPath + "' stream.");
            }
        }
    }

    @Override
    public void destroy() throws ActionLifecycleException {
    }

    @Override
    public synchronized Message process(Message message) throws ActionProcessingException {
        try {
            Script execScript = this.getScript(message);
            Binding binding = new Binding();
            binding.setVariable("message", (Object)message);
            binding.setVariable("config", (Object)this.configTree);
            binding.setVariable("payloadProxy", (Object)this.payloadProxy);
            binding.setVariable("logger", (Object)logger);
            execScript.setBinding(binding);
            Object returnVal = execScript.run();
            if (returnVal instanceof Message) {
                return (Message)returnVal;
            }
            return message;
        }
        catch (Exception e) {
            logger.error((Object)"Error executing Groovy script.", (Throwable)e);
            throw new ActionProcessingException("Error executing Groovy script.", e);
        }
    }

    protected Script getScript(Message message) throws ActionProcessingException {
        Object messageScript;
        if (this.scriptPath != null) {
            if (this.script == null || !this.cacheScript) {
                try {
                    String scriptText = GroovyActionProcessor.getScriptFromClasspath(this.scriptPath);
                    this.script = this.constructScriptInstance(scriptText);
                }
                catch (IOException e) {
                    throw new ActionProcessingException("Error reading script '" + this.scriptPath + "' stream.");
                }
            }
            return this.script;
        }
        try {
            messageScript = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        if (messageScript instanceof String) {
            return this.constructScriptInstance((String)messageScript);
        }
        if (messageScript instanceof byte[]) {
            return this.constructScriptInstance(new String((byte[])messageScript));
        }
        throw new ActionProcessingException("Groovy script not specified in message.");
    }

    private Script constructScriptInstance(String scriptText) {
        GroovyShell shell = new GroovyShell(Thread.currentThread().getContextClassLoader());
        return shell.parse(scriptText);
    }

    @Override
    public void processException(Message message, Throwable th) {
    }

    @Override
    public void processSuccess(Message message) {
    }
}

