/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.http;

import java.io.IOException;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.routing.http.AbstractHttpMethodFactory;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class POSTHttpMethodFactory
extends AbstractHttpMethodFactory {
    public static final String CONTENT_TYPE = "org.jboss.soa.esb.actions.routing.http.contentType";
    public static final String CHARSET = "org.jboss.soa.esb.actions.routing.http.charset";
    private MessagePayloadProxy payloadProxy;
    private String _contentType = null;
    private String _charset = null;

    @Override
    public void setConfiguration(ConfigTree config) throws ConfigurationException {
        this.payloadProxy = new MessagePayloadProxy(config);
        this._contentType = config.getAttribute(CONTENT_TYPE);
        this._charset = config.getAttribute(CHARSET);
    }

    @Override
    public HttpMethodBase getInstance(Message message) throws IOException {
        Object entity;
        PostMethod method = new PostMethod(this.getEndpointPathAndQuery());
        try {
            Object payload = this.payloadProxy.getPayload(message);
            entity = payload instanceof byte[] ? new ByteArrayRequestEntity((byte[])payload, this._contentType) : new StringRequestEntity(String.valueOf(payload), this._contentType, this._charset);
        }
        catch (MessageDeliverException e) {
            IOException ioe = new IOException("Failed to access message payload.");
            ioe.initCause(e);
            throw ioe;
        }
        method.setRequestEntity((RequestEntity)entity);
        return method;
    }
}

