/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing.email;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.routing.AbstractRouter;
import org.jboss.soa.esb.actions.routing.email.Emailer;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;

public class EmailRouter
extends AbstractRouter {
    private Emailer emailer;
    private ConfigTree config;

    public EmailRouter(ConfigTree config) throws ConfigurationException {
        super(config);
        this.emailer = new Emailer(config);
        this.config = config;
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        Emailer.overrideSmtpProperties(message, this.config);
        return super.process(message);
    }

    @Override
    public void route(Object object) throws ActionProcessingException {
        try {
            this.emailer.sendEmail(this.config, object);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException("Exception while trying to send email.", e);
        }
    }
}

