/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.routing;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class EchoRouter
extends AbstractActionPipelineProcessor {
    private static Logger logger = Logger.getLogger(EchoRouter.class);
    private MessagePayloadProxy payloadProxy;

    public EchoRouter(ConfigTree configTree) {
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        if (logger.isInfoEnabled()) {
            Object content;
            try {
                content = this.payloadProxy.getPayload(message);
            }
            catch (MessageDeliverException e) {
                throw new ActionProcessingException(e);
            }
            logger.info((Object)("EchoRouter currently routing message " + message + " with payload <<" + content + ">>"));
        }
        return message;
    }
}

