/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

public class ImplicitCollectionConf {
    private Class<?> ownerType;
    private String fieldName;
    private String itemFieldName;
    private Class<?> itemType;

    public ImplicitCollectionConf(String ownerType, String fieldName, String itemFieldName, String itemType) {
        AssertArgument.isNotNullAndNotEmpty(ownerType, "ownerType");
        AssertArgument.isNotNullAndNotEmpty(fieldName, "fieldName");
        this.ownerType = this.loadClass(ownerType);
        this.fieldName = fieldName;
        this.itemFieldName = itemFieldName;
        if (itemType != null) {
            this.itemType = this.loadClass(itemType);
        }
    }

    public Class<?> getOwnerType() {
        return this.ownerType;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getItemFieldName() {
        return this.itemFieldName;
    }

    public Class<?> getItemType() {
        return this.itemType;
    }

    public String toString() {
        return "ImplicitCollectionConf [ownerType=" + this.ownerType + ", fieldName=" + this.fieldName + ", itemFieldName=" + this.itemFieldName + ", itemType=" + this.itemType + "]";
    }

    private Class<?> loadClass(String className) {
        try {
            return ClassUtil.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}

