/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

public class FieldAliasConf {
    private String alias;
    private Class<?> definedIn;
    private String fieldName;

    public FieldAliasConf(String alias, String definedIn, String fieldName) {
        AssertArgument.isNotNullAndNotEmpty(alias, "alias");
        AssertArgument.isNotNullAndNotEmpty(definedIn, "definedIn");
        AssertArgument.isNotNullAndNotEmpty(fieldName, "fieldName");
        this.alias = alias;
        this.definedIn = this.loadClass(definedIn);
        this.fieldName = fieldName;
    }

    public String getAlias() {
        return this.alias;
    }

    public Class<?> getDefinedIn() {
        return this.definedIn;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return "FieldAliasConf [alias=" + this.alias + ", definedIn=" + this.definedIn + ", fieldName=" + this.fieldName + "]";
    }

    private Class<?> loadClass(String className) {
        try {
            return ClassUtil.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}

