/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters.xstream.conf;

import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.util.ClassUtil;

public class AttributeAliasConf {
    private String attribute;
    private Class<?> definedIn;

    public AttributeAliasConf(String attribute, String definedIn) {
        AssertArgument.isNotNullAndNotEmpty(attribute, "attribute");
        AssertArgument.isNotNullAndNotEmpty(definedIn, "definedIn");
        this.attribute = attribute;
        this.definedIn = this.loadClass(definedIn);
    }

    public String getAttribute() {
        return this.attribute;
    }

    public Class<?> getDefinedIn() {
        return this.definedIn;
    }

    public String toString() {
        return "AttributeAliasConf [attribute=" + this.attribute + ", definedIn=" + this.definedIn + "]";
    }

    private Class<?> loadClass(String className) {
        try {
            return ClassUtil.forName(className, this.getClass());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Could not load class '" + className + "'", e);
        }
    }
}

