/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.DomDriver;
import com.thoughtworks.xstream.io.xml.DomReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.converters.AbstractObjectXStream;
import org.jboss.soa.esb.actions.converters.xstream.conf.FieldAliasConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.ImplicitCollectionConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.XStreamConfigurator;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.ClassUtil;
import org.jboss.soa.esb.util.XPathUtil;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class XStreamToObject
extends AbstractObjectXStream {
    private static Logger logger = Logger.getLogger(XStreamToObject.class);
    private Class<?> incomingType;
    private Map<String, String> aliases;
    private Map<String, String> attributeAliases;
    private List<FieldAliasConf> fieldAliases;
    private List<String> converters;
    private List<ImplicitCollectionConf> implicitCollections;
    private MessagePayloadProxy payloadProxy;

    public XStreamToObject(ConfigTree properties) {
        this(properties.getName(), properties.attributesAsList());
        XStreamConfigurator xstreamConfig = new XStreamConfigurator(properties);
        this.aliases = this.getAliases(properties, "alias");
        this.fieldAliases = xstreamConfig.getFieldAliases();
        this.attributeAliases = this.getAliases(properties, "attribute-alias");
        this.converters = this.getConverters(properties, "converter");
        this.implicitCollections = xstreamConfig.getImplicitCollections();
        this.payloadProxy = new MessagePayloadProxy(properties, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
    }

    protected XStreamToObject(String actionName, List<KeyValuePair> properties) {
        super(actionName, properties);
        String incomingTypeStr = KeyValuePair.getValue("incoming-type", properties);
        try {
            this.incomingType = ClassUtil.forName(incomingTypeStr, this.getClass());
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Could not find : " + incomingTypeStr), (Throwable)e);
        }
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        Object object;
        try {
            object = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        try {
            Object toObject = this.incomingType.newInstance();
            toObject = this.fromXmlToObject(object.toString(), toObject);
            this.payloadProxy.setPayload(message, toObject);
        }
        catch (InstantiationException e) {
            logger.error((Object)e);
            throw new ActionProcessingException("Could not invoke for Arg: " + this.getName(), e);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)e);
            throw new ActionProcessingException("Could not access for Arg: " + this.getName(), e);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        return message;
    }

    protected Map<String, String> getAliases(ConfigTree configTree, String childName) {
        HashMap<String, String> aliases = new HashMap<String, String>();
        ConfigTree[] children = configTree.getChildren(childName);
        if (children != null) {
            for (ConfigTree alias : children) {
                aliases.put(alias.getAttribute("name"), alias.getAttribute("class"));
            }
        }
        return aliases;
    }

    protected List<FieldAliasConf> getFieldAliases(ConfigTree configTree, String childName) {
        ArrayList<FieldAliasConf> aliases = new ArrayList<FieldAliasConf>();
        ConfigTree[] children = configTree.getChildren(childName);
        if (children != null) {
            for (ConfigTree alias : children) {
                aliases.add(new FieldAliasConf(alias.getAttribute("alias"), alias.getAttribute("class"), alias.getAttribute("fieldName")));
            }
        }
        return aliases;
    }

    protected List<String> getConverters(ConfigTree configTree, String childName) {
        ArrayList<String> converters = new ArrayList<String>();
        ConfigTree[] children = configTree.getChildren(childName);
        if (children != null) {
            for (ConfigTree converter : children) {
                converters.add(converter.getAttribute("class"));
            }
        }
        return converters;
    }

    protected void addAliases(Map<String, String> aliases, XStream xstream) throws ActionProcessingException {
        if (aliases == null) {
            return;
        }
        Set<Map.Entry<String, String>> set = aliases.entrySet();
        for (Map.Entry<String, String> me : set) {
            String className = me.getValue();
            try {
                Class clazz = ClassUtil.forName(className, this.getClass());
                xstream.alias(me.getKey(), clazz);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"ClassNotFoundException: ", (Throwable)e);
                throw new ActionProcessingException("Could not add alias : " + me.getKey() + ", class : " + className, e);
            }
        }
    }

    protected void addConverters(List<String> converters, XStream xstream) throws ActionProcessingException {
        if (converters == null) {
            return;
        }
        for (String converterClass : converters) {
            if (converterClass == null) continue;
            try {
                Class clazz = ClassUtil.forName(converterClass, this.getClass());
                xstream.registerConverter((Converter)clazz.newInstance());
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"ClassNotFoundException: ", (Throwable)e);
                throw new ActionProcessingException("Could not register converter : " + converterClass.getClass().getName(), e);
            }
            catch (InstantiationException e) {
                logger.error((Object)"InstantiationException: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error((Object)"IllegalAccessException: ", (Throwable)e);
            }
        }
    }

    protected void addAttributeAliases(Map<String, String> aliases, XStream xstream) throws ActionProcessingException {
        if (aliases == null) {
            return;
        }
        Set<Map.Entry<String, String>> set = aliases.entrySet();
        for (Map.Entry<String, String> me : set) {
            String className = me.getValue();
            try {
                Class clazz = ClassUtil.forName(className, this.getClass());
                xstream.useAttributeFor(me.getKey(), clazz);
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)"ClassNotFoundException: ", (Throwable)e);
                throw new ActionProcessingException("Could not add alias : " + me.getKey() + ", class : " + className, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object fromXmlToObject(String xml, Object root) throws ActionProcessingException {
        DomReader reader = null;
        try {
            reader = new DomReader(this.getRootElement(xml, this.rootNodeName));
            XStream xstream = new XStream((HierarchicalStreamDriver)new DomDriver());
            xstream.alias(this.getAlias(this.incomingType), this.incomingType);
            this.addAliases(this.aliases, xstream);
            XStreamConfigurator.addFieldAliases(this.fieldAliases, xstream);
            this.addAttributeAliases(this.attributeAliases, xstream);
            this.addConverters(this.converters, xstream);
            XStreamConfigurator.addImplicitCollections(this.implicitCollections, xstream);
            Object object = xstream.unmarshal((HierarchicalStreamReader)reader, root);
            return object;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private Element getRootElement(String xml, String xPathExpression) throws ActionProcessingException {
        try {
            return XPathUtil.getNodeFromXPathExpression(xml, xPathExpression);
        }
        catch (ParserConfigurationException e) {
            logger.error((Object)"ParserConfigurationException:", (Throwable)e);
            throw new ActionProcessingException(e);
        }
        catch (SAXException e) {
            logger.error((Object)"SAXException : ", (Throwable)e);
            throw new ActionProcessingException(e);
        }
        catch (IOException e) {
            logger.error((Object)"IOException: ", (Throwable)e);
            throw new ActionProcessingException(e);
        }
        catch (XPathExpressionException e) {
            logger.error((Object)"XPathExpressionException", (Throwable)e);
            throw new ActionProcessingException(e);
        }
    }
}

