/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.QNameMap;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.actions.converters.xstream.conf.ClassAliasConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.ConverterConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.FieldAliasConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.ImplicitCollectionConf;
import org.jboss.soa.esb.actions.converters.xstream.conf.XStreamConfigurator;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class ObjectToXStream
extends AbstractActionPipelineProcessor {
    public static final String ATTR_CLASS_ALIAS = "class-alias";
    public static final String ATTR_EXCLUDE_PACKAGE = "exclude-package";
    public static final String ATTR_NAMESPACE_URI = "namespace-uri";
    public static final String ATTR_NAMESPACE_LOCALPART = "local-part";
    public static final String ATTR_XSTREAM_MODE = "xstream-mode";
    private String classAlias;
    private boolean excludePackage;
    private MessagePayloadProxy payloadProxy;
    private Map<String, String> namespaces;
    private String mode;
    private List<ClassAliasConf> classAliases;
    private List<FieldAliasConf> fieldAliases;
    private List<ImplicitCollectionConf> implicitCollections;
    private List<ConverterConf> converters;

    public ObjectToXStream(ConfigTree configTree) {
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
        this.classAlias = configTree.getAttribute(ATTR_CLASS_ALIAS);
        this.excludePackage = configTree.getAttribute(ATTR_EXCLUDE_PACKAGE, "true").equals("true");
        this.namespaces = this.getNamespaces(configTree);
        this.mode = configTree.getAttribute(ATTR_XSTREAM_MODE, "XPATH_RELATIVE_REFERENCES");
        XStreamConfigurator xstreamConfig = new XStreamConfigurator(configTree);
        this.classAliases = xstreamConfig.getClassAliases();
        this.fieldAliases = xstreamConfig.getFieldAliases();
        this.implicitCollections = xstreamConfig.getImplicitCollections();
        this.converters = xstreamConfig.getConverters();
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        Object object;
        try {
            object = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        XStream xstream = this.createXStreamInstance();
        if (this.classAlias == null) {
            if (this.excludePackage) {
                xstream.alias(object.getClass().getSimpleName(), object.getClass());
            } else {
                xstream.alias(object.getClass().getName(), object.getClass());
            }
        } else {
            xstream.alias(this.classAlias, object.getClass());
        }
        XStreamConfigurator.addClassAliases(this.classAliases, xstream);
        XStreamConfigurator.addFieldAliases(this.fieldAliases, xstream);
        XStreamConfigurator.addImplicitCollections(this.implicitCollections, xstream);
        XStreamConfigurator.addConverters(this.converters, xstream);
        try {
            String xml = xstream.toXML(object);
            this.payloadProxy.setPayload(message, xml);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        return message;
    }

    protected XStream createXStreamInstance() {
        if (this.namespaces == null || this.namespaces.size() == 0) {
            return new XStream();
        }
        QNameMap nsm = new QNameMap();
        for (Map.Entry<String, String> me : this.namespaces.entrySet()) {
            String namespaceURI = me.getKey();
            String localPart = me.getValue();
            nsm.registerMapping(new QName(namespaceURI, localPart), localPart);
        }
        XStream stream = new XStream((HierarchicalStreamDriver)new StaxDriver(nsm));
        if (!"XPATH_RELATIVE_REFERENCES".equals(this.mode)) {
            if ("XPATH_ABSOLUTE_REFERENCES".equals(this.mode)) {
                stream.setMode(1004);
            } else if ("ID_REFERENCES".equals(this.mode)) {
                stream.setMode(1002);
            } else if ("NO_REFERENCES".equals(this.mode)) {
                stream.setMode(1001);
            }
        }
        return stream;
    }

    protected Map<String, String> getNamespaces(ConfigTree configTree) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        ConfigTree[] children = configTree.getChildren("namespace");
        if (children != null) {
            for (ConfigTree namespace : children) {
                namespaces.put(namespace.getAttribute(ATTR_NAMESPACE_URI), namespace.getAttribute(ATTR_NAMESPACE_LOCALPART));
            }
        }
        return namespaces;
    }
}

