/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class ObjectToCSVString
extends AbstractActionPipelineProcessor {
    public static final String BEAN_PROPERTIES_PROP = "bean-properties";
    public static final String FAIL_ON_MISSING_PROPERTY = "fail-on-missing-property";
    private static Logger logger = Logger.getLogger(ObjectToCSVString.class);
    private List<String> propertyMethodNames = new ArrayList<String>();
    private boolean failOnMissingProperty;
    private MessagePayloadProxy payloadProxy;

    public ObjectToCSVString(ConfigTree properties) throws ConfigurationException {
        this("ObjectToCSVString", properties.attributesAsList());
        this.payloadProxy = new MessagePayloadProxy(properties, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
    }

    private ObjectToCSVString(String actionName, List<KeyValuePair> properties) throws ConfigurationException {
        String objectProps = KeyValuePair.getValue(BEAN_PROPERTIES_PROP, properties);
        if (objectProps == null || objectProps.trim().equals("")) {
            throw new ConfigurationException("Action [" + actionName + "] must specify a comma seperated object bean property list via a '" + BEAN_PROPERTIES_PROP + "' property setting.");
        }
        String[] propertyNames = objectProps.split(",");
        StringBuffer methodNameConstructionBuffer = new StringBuffer();
        for (String propertyName : propertyNames) {
            if ((propertyName = propertyName.trim()).equals("")) continue;
            methodNameConstructionBuffer.setLength(0);
            methodNameConstructionBuffer.append("get");
            methodNameConstructionBuffer.append(propertyName);
            methodNameConstructionBuffer.setCharAt(3, Character.toUpperCase(methodNameConstructionBuffer.charAt(3)));
            this.propertyMethodNames.add(methodNameConstructionBuffer.toString());
        }
        this.failOnMissingProperty = KeyValuePair.getBooleanValue(FAIL_ON_MISSING_PROPERTY, properties, false);
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        Object oCurr = null;
        try {
            oCurr = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        Class<?> oCurrClass = null == oCurr ? null : oCurr.getClass();
        StringBuffer csv = new StringBuffer();
        boolean hasAppendStarted = false;
        for (String methodName : this.propertyMethodNames) {
            Method method;
            if (hasAppendStarted) {
                csv.append(",");
            }
            hasAppendStarted = true;
            try {
                method = oCurrClass.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                String exceptionMessage = "Bean method: " + methodName + " not found/accessible on message object " + oCurr.getClass().getName();
                logger.error((Object)exceptionMessage, (Throwable)e);
                if (this.failOnMissingProperty) {
                    throw new ActionProcessingException(exceptionMessage, e);
                }
                csv.append("<no-such-property>");
                continue;
            }
            try {
                Object value = method.invoke(oCurr, new Object[0]);
                csv.append(value != null ? value.toString() : "");
            }
            catch (Exception e) {
                logger.error((Object)("Exception calling bean method: " + methodName), (Throwable)e);
            }
        }
        try {
            this.payloadProxy.setPayload(message, csv.toString());
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        return message;
    }
}

