/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.util.ClassUtil;

public class ObjectInvoke
extends AbstractActionPipelineProcessor {
    private static Logger logger = Logger.getLogger(ObjectInvoke.class);
    private String classProcessor;
    private Class processorClass;
    private Method method;
    private String classMethod;
    private String name;
    private MessagePayloadProxy payloadProxy;

    public ObjectInvoke(ConfigTree configTree) {
        this.payloadProxy = new MessagePayloadProxy(configTree, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
        this.name = configTree.getName();
        this.classProcessor = configTree.getAttribute("class-processor");
        this.classMethod = configTree.getAttribute("class-method");
        if (this.classMethod == null || this.classMethod.length() == 0) {
            this.classMethod = this.name;
        }
        if (this.classProcessor == null) {
            return;
        }
        try {
            this.processorClass = ClassUtil.forName(this.classProcessor, this.getClass());
            this.setUpMethod(this.processorClass);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)("Not able to find class: " + this.classProcessor), (Throwable)e);
        }
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        Object result;
        Object object = null;
        try {
            object = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        Object processor = this.getObjectToInvoke();
        Method m = this.setUpMethod(processor);
        try {
            result = m.invoke(processor, object);
        }
        catch (IllegalArgumentException e) {
            throw new ActionProcessingException("Invalid arguments for class-processor [ " + this.classProcessor + "] for Action Processor: " + this.name, e);
        }
        catch (IllegalAccessException e) {
            throw new ActionProcessingException("No access for class-processor [ " + this.classProcessor + "] for Action Processor: " + this.name, e);
        }
        catch (InvocationTargetException e) {
            throw new ActionProcessingException("Invocation problem with class-processor [ " + this.classProcessor + "] for Action Processor: " + this.name, e);
        }
        try {
            this.payloadProxy.setPayload(message, result);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        return message;
    }

    protected Object getObjectToInvoke() throws ActionProcessingException {
        Object processor = null;
        try {
            processor = this.processorClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ActionProcessingException("Could not invoke class-processor [ " + this.classProcessor + "] for Action Processor: " + this.name, e);
        }
        catch (IllegalAccessException e) {
            throw new ActionProcessingException("Could not access class-processor [ " + this.classProcessor + "] for Action Processor: " + this.name, e);
        }
        return processor;
    }

    protected Method setUpMethod(Object obj) {
        if (this.method != null) {
            return this.method;
        }
        this.processorClass = obj instanceof Class ? (Class)obj : obj.getClass();
        Method[] methods = this.processorClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (!m.getName().equals(this.classMethod)) continue;
            this.method = m;
            break;
        }
        return this.method;
    }
}

