/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.converters;

import java.io.UnsupportedEncodingException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class ByteArrayToString
extends AbstractActionPipelineProcessor {
    private String encoding;
    private MessagePayloadProxy payloadProxy;

    public ByteArrayToString(ConfigTree config) {
        this.encoding = config.getAttribute("encoding", "UTF-8");
        this.payloadProxy = new MessagePayloadProxy(config, new String[]{"org.jboss.soa.esb.message.content.bytes", "org.jboss.soa.esb.actions.post"}, new String[]{"org.jboss.soa.esb.actions.post"});
    }

    @Override
    public Message process(Message message) throws ActionProcessingException {
        byte[] bytes;
        try {
            bytes = (byte[])this.payloadProxy.getPayload(message);
        }
        catch (ClassCastException e) {
            throw new ActionProcessingException("Message must be an array of bytes. Is " + message.getClass().getName());
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        try {
            this.payloadProxy.setPayload(message, new String(bytes, this.encoding));
            return message;
        }
        catch (UnsupportedEncodingException e) {
            throw new ActionProcessingException("Unable to decode byte[] to String. Unsupported character encoding configuration: " + this.encoding, e);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
    }
}

