/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.cbr;

import java.io.ByteArrayInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.cbr.AbstractPropertyRulesRouter;
import org.jboss.soa.esb.actions.cbr.RoutingRule;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.util.XPathNamespaceContext;
import org.milyn.payload.StringSource;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XPathRouter
extends AbstractPropertyRulesRouter {
    private XPathNamespaceContext namespaceContext;

    @Override
    public void setConfigTree(ConfigTree configTree) throws MessageRouterException {
        try {
            this.namespaceContext = new NamespaceContext(configTree.getChildren("namespace"));
        }
        catch (ConfigurationException e) {
            throw new MessageRouterException("Error loading namespace prefix mappings.", e);
        }
        super.setConfigTree(configTree);
    }

    @Override
    public Map<String, RoutingRule> buildRoutingMap(Properties rules) throws MessageRouterException {
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xpath = xPathFactory.newXPath();
        HashMap<String, RoutingRule> routingMap = new HashMap<String, RoutingRule>();
        xpath.setNamespaceContext(this.namespaceContext);
        Set<Map.Entry<Object, Object>> ruleSet = rules.entrySet();
        for (Map.Entry<Object, Object> rule : ruleSet) {
            String destinationName = (String)rule.getKey();
            String expression = (String)rule.getValue();
            try {
                routingMap.put(destinationName, new XPathRoutingRule(xpath.compile(expression)));
            }
            catch (XPathExpressionException e) {
                throw new MessageRouterException("Error compiling XPath expression '" + expression + "'.", e);
            }
        }
        return routingMap;
    }

    public javax.xml.namespace.NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    private static class NamespaceContext
    extends XPathNamespaceContext {
        public NamespaceContext(ConfigTree[] namespaces) throws ConfigurationException {
            if (namespaces != null) {
                for (ConfigTree namespace : namespaces) {
                    String prefix = namespace.getRequiredAttribute("prefix");
                    String uri = namespace.getRequiredAttribute("uri");
                    this.setMapping(prefix, uri);
                }
            }
        }
    }

    private class XPathRoutingRule
    implements RoutingRule {
        private XPathExpression xpathExpression;

        private XPathRoutingRule(XPathExpression xpathExpression) {
            this.xpathExpression = xpathExpression;
        }

        @Override
        public boolean evaluate(Object objectToTest) throws MessageRouterException {
            try {
                if (objectToTest instanceof String) {
                    XMLEventReader reader = XMLHelper.getXMLEventReader((Source)new StringSource((String)objectToTest));
                    Document doc = XMLHelper.createDocument(reader);
                    return (Boolean)this.xpathExpression.evaluate(doc, XPathConstants.BOOLEAN);
                }
                if (objectToTest instanceof byte[]) {
                    XMLEventReader reader = XMLHelper.getXMLEventReader(new ByteArrayInputStream((byte[])objectToTest));
                    Document doc = XMLHelper.createDocument(reader);
                    return (Boolean)this.xpathExpression.evaluate(doc, XPathConstants.BOOLEAN);
                }
                if (objectToTest instanceof Node || objectToTest instanceof NodeList) {
                    return (Boolean)this.xpathExpression.evaluate(objectToTest, XPathConstants.BOOLEAN);
                }
                if (XPathRouter.this.logger.isDebugEnabled()) {
                    XPathRouter.this.logger.debug((Object)("Unsupported XPath evaluation type '" + objectToTest.getClass().getName() + "'."));
                }
            }
            catch (ParserConfigurationException e) {
                XPathRouter.this.logger.debug((Object)"Error evaluating xpath expression.", (Throwable)e);
            }
            catch (XMLStreamException e) {
                XPathRouter.this.logger.debug((Object)"Error evaluating xpath expression.", (Throwable)e);
            }
            catch (XPathExpressionException e) {
                XPathRouter.this.logger.debug((Object)"Error evaluating xpath expression.", (Throwable)e);
            }
            return false;
        }
    }
}

