/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions.cbr;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.ContentBasedWiretap;
import org.jboss.soa.esb.actions.cbr.RoutingRule;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.mapping.ObjectMapper;
import org.jboss.soa.esb.message.mapping.ObjectMappingException;
import org.jboss.soa.esb.services.routing.MessageRouterException;
import org.jboss.soa.esb.services.routing.cbr.ContentBasedRouter;
import org.jboss.soa.esb.util.ClassUtil;

abstract class AbstractPropertyRulesRouter
implements ContentBasedRouter {
    protected Logger logger = Logger.getLogger(this.getClass());
    private String ruleSetConfig;
    private File ruleSetFile;
    private long lastLoaded = 0L;
    private Map<String, RoutingRule> routingMap;
    private MessagePayloadProxy payloadProxy;

    protected AbstractPropertyRulesRouter() {
    }

    @Override
    public void setConfigTree(ConfigTree configTree) throws MessageRouterException {
        this.ruleSetConfig = configTree.getAttribute("ruleSet");
        if (this.ruleSetConfig != null) {
            this.ruleSetFile = new File(this.ruleSetConfig);
            this.routingMap = this.buildRoutingMap(this.loadRules());
        } else {
            ConfigTree[] routeToConfigs = configTree.getChildren("route-to");
            Properties rules = new Properties();
            for (ConfigTree routeToConfig : routeToConfigs) {
                try {
                    String destinationName = ContentBasedWiretap.buildDestinationKey(routeToConfig);
                    String expression = routeToConfig.getRequiredAttribute("expression");
                    rules.setProperty(destinationName, expression);
                }
                catch (ConfigurationException e) {
                    throw new MessageRouterException("Error processing <rule> configuration.", e);
                }
            }
            this.routingMap = this.buildRoutingMap(rules);
        }
        this.payloadProxy = new MessagePayloadProxy(configTree);
    }

    public Map<String, RoutingRule> getRoutingMap() {
        return this.routingMap;
    }

    public abstract Map<String, RoutingRule> buildRoutingMap(Properties var1) throws MessageRouterException;

    @Override
    public List<String> route(String ruleSet, String ruleLanguage, boolean ruleReload, Message message, List<Object> objectList) throws MessageRouterException {
        return this.route(ruleSet, ruleReload, message, objectList);
    }

    @Override
    public List<String> route(String ruleSet, boolean ruleReload, Message message, List<Object> objectList) throws MessageRouterException {
        if (ruleReload && this.ruleSetFile != null && this.ruleSetFile.exists() && this.ruleSetFile.lastModified() != this.lastLoaded) {
            this.routingMap = this.buildRoutingMap(this.loadRules());
        }
        List<Object> objectsToTest = this.getMessageObjectsToTest(message, objectList);
        ArrayList<String> destinations = new ArrayList<String>();
        Set<Map.Entry<String, RoutingRule>> routingRules = this.routingMap.entrySet();
        for (Map.Entry<String, RoutingRule> routingRule : routingRules) {
            for (Object objectToTest : objectsToTest) {
                if (!routingRule.getValue().evaluate(objectToTest)) continue;
                destinations.add(routingRule.getKey());
            }
        }
        return destinations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties loadRules() throws MessageRouterException {
        InputStream ruleStream;
        if (this.ruleSetFile.exists()) {
            try {
                ruleStream = new FileInputStream(this.ruleSetFile);
            }
            catch (FileNotFoundException e) {
                throw new MessageRouterException("Unable to open rule properties file '" + this.ruleSetFile.getAbsolutePath() + "'.", e);
            }
            this.lastLoaded = this.ruleSetFile.lastModified();
        } else {
            ruleStream = ClassUtil.getResourceAsStream(this.ruleSetConfig, AbstractPropertyRulesRouter.class);
        }
        if (ruleStream == null) {
            throw new MessageRouterException("Unable to open rule properties file '" + this.ruleSetConfig + "'.");
        }
        Properties rules = new Properties();
        try {
            try {
                rules.load(ruleStream);
            }
            catch (IOException e) {
                throw new MessageRouterException("Error reading rule properties file '" + this.ruleSetConfig + "'.", e);
            }
        }
        finally {
            try {
                ruleStream.close();
            }
            catch (IOException e) {
                throw new MessageRouterException("Error closing rule properties file '" + this.ruleSetConfig + "'.", e);
            }
        }
        return rules;
    }

    private List<Object> getMessageObjectsToTest(Message message, List<Object> objectList) throws MessageRouterException {
        ArrayList<Object> objectsToTest = new ArrayList<Object>();
        if (objectList == null || objectList.isEmpty()) {
            try {
                objectsToTest.add(this.payloadProxy.getPayload(message));
            }
            catch (MessageDeliverException e) {
                throw new MessageRouterException("Failed to get message payload from message.", e);
            }
        } else {
            ObjectMapper objectMapper = new ObjectMapper();
            for (Object object : objectList) {
                if (!(object instanceof String)) continue;
                try {
                    Object mappedObject = objectMapper.getObjectFromMessage(message, (String)object);
                    if (mappedObject == null) {
                        this.logger.debug((Object)("Object '" + object + "' not present on message."));
                        continue;
                    }
                    objectsToTest.add(mappedObject);
                }
                catch (ObjectMappingException e) {
                    this.logger.debug((Object)("Object '" + object + "' not present on message."));
                }
            }
        }
        return objectsToTest;
    }
}

