/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.addressing.Call;
import org.jboss.soa.esb.addressing.EPR;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;

public class SyncServiceInvoker
extends AbstractActionPipelineProcessor {
    private static Logger logger = Logger.getLogger(SyncServiceInvoker.class);
    private ServiceInvoker serviceInvoker;
    private long timeout;
    private boolean failOnException;
    private boolean suspendTransaction;

    public SyncServiceInvoker(ConfigTree configTree) throws ConfigurationException, MessageDeliverException {
        String serviceCat = configTree.getRequiredAttribute("service-category");
        String serviceName = configTree.getRequiredAttribute("service-name");
        this.serviceInvoker = new ServiceInvoker(serviceCat, serviceName);
        this.timeout = configTree.getLongAttribute("serviceInvokerTimeout", 30000L);
        this.failOnException = configTree.getBooleanAttribute("failOnException", true);
        this.suspendTransaction = configTree.getBooleanAttribute("suspendTransaction", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message process(Message message) throws ActionProcessingException {
        Call call = message.getHeader().getCall();
        EPR faultTo = call.getFaultTo();
        EPR replyTo = call.getReplyTo();
        Object txObject = null;
        if (this.isTransactional() && this.suspendTransaction) {
            try {
                txObject = TransactionStrategy.getTransactionStrategy(true).suspend();
            }
            catch (TransactionStrategyException e) {
                throw new ActionProcessingException("Error suspending transaction on service '" + this.serviceInvoker.getService() + "'", e);
            }
        }
        try {
            call.setFaultTo(null);
            call.setReplyTo(null);
            Message e = this.serviceInvoker.deliverSync(message, this.timeout);
            return e;
        }
        catch (Exception e) {
            call.setFaultTo(faultTo);
            call.setReplyTo(replyTo);
            if (this.failOnException) {
                throw new ActionProcessingException("Error delivering message to service '" + this.serviceInvoker.getService() + "'", e);
            }
            logger.debug((Object)"Exception during deliverSync().  Action configured to continue.", (Throwable)e);
            Message message2 = message;
            return message2;
        }
        finally {
            try {
                if (txObject != null) {
                    TransactionStrategy.getTransactionStrategy(true).resume(txObject);
                }
            }
            catch (TransactionStrategyException e) {
                throw new ActionProcessingException("Error resuming transaction on service '" + this.serviceInvoker.getService() + "'", e);
            }
        }
    }

    private boolean isTransactional() throws ActionProcessingException {
        try {
            TransactionStrategy txStrategy = TransactionStrategy.getTransactionStrategy(true);
            if (txStrategy == null) {
                return false;
            }
            if (txStrategy.getTransaction() != null) {
                if (txStrategy.isActive()) {
                    return true;
                }
                throw new ActionProcessingException("Associated transaction is no longer active!");
            }
        }
        catch (TransactionStrategyException ex) {
            throw new ActionProcessingException("Could not determine transactionality.", ex);
        }
        return false;
    }
}

