/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.actions.AbstractActionPipelineProcessor;
import org.jboss.soa.esb.actions.ActionProcessingException;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;

public class StoreMessageToFile
extends AbstractActionPipelineProcessor {
    private static final Logger LOG = Logger.getLogger(StoreMessageToFile.class);
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final Lock globalLock = new ReentrantLock();
    public static final String FILENAME = "filename";
    public static final String LOCATION = "location";
    public static final String RAW = "raw";
    public static final String PROPERTY_JBESB_FILENAME = "jbesbfilename";
    public static final String MESSAGE_CONTENT_FILENAME_START = "[jbesb-filename]";
    public static final String MESSAGE_CONTENT_FILENAME_END = "[/jbesb-filename]";
    private MessagePayloadProxy payloadProxy;
    private final String filename;
    private final boolean raw;

    public StoreMessageToFile(ConfigTree config) {
        this.filename = config.getAttribute(FILENAME);
        String location = config.getAttribute(LOCATION);
        if (location != null) {
            config.setAttribute("get-payload-location", location);
        }
        this.payloadProxy = new MessagePayloadProxy(config);
        this.payloadProxy.setNullGetPayloadHandling(MessagePayloadProxy.NullPayloadHandling.LOG);
        this.raw = Boolean.parseBoolean(config.getAttribute(RAW, "false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message process(Message message) throws ActionProcessingException {
        Object contents;
        try {
            contents = this.payloadProxy.getPayload(message);
        }
        catch (MessageDeliverException e) {
            throw new ActionProcessingException(e);
        }
        if (contents != null) {
            int endIndex;
            int startIndex;
            Object jbesbfilename;
            String messageVal = contents instanceof byte[] ? new String((byte[])contents) : contents.toString();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Message value: " + messageVal));
            }
            String storeFilename = this.filename != null ? this.filename : ((jbesbfilename = message.getProperties().getProperty(PROPERTY_JBESB_FILENAME)) != null ? jbesbfilename.toString() : ((startIndex = messageVal.indexOf(MESSAGE_CONTENT_FILENAME_START)) != -1 ? ((endIndex = messageVal.indexOf(MESSAGE_CONTENT_FILENAME_END)) != -1 && endIndex > startIndex ? messageVal.substring(startIndex + MESSAGE_CONTENT_FILENAME_START.length(), endIndex) : null) : null));
            if (storeFilename == null) {
                LOG.debug((Object)"Store filename is null");
            } else {
                File outputFile;
                File storeFile = new File(storeFilename);
                if (storeFile.isAbsolute()) {
                    outputFile = storeFile;
                } else {
                    String tmpDir = System.getProperty("java.io.tmpdir");
                    outputFile = new File(tmpDir, storeFilename);
                }
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Storing message in filename: " + outputFile.getCanonicalPath()));
                    }
                    globalLock.lock();
                    try {
                        FileWriter fw = new FileWriter(outputFile, true);
                        try {
                            if (this.raw) {
                                fw.write(messageVal);
                            } else {
                                String line;
                                StringReader sr = new StringReader(messageVal);
                                BufferedReader br = new BufferedReader(sr);
                                while ((line = br.readLine()) != null) {
                                    fw.write(line);
                                }
                                fw.write(NEWLINE);
                            }
                            fw.flush();
                        }
                        finally {
                            try {
                                fw.close();
                            }
                            catch (Throwable th) {}
                        }
                    }
                    finally {
                        globalLock.unlock();
                    }
                }
                catch (IOException ioe) {
                    LOG.warn((Object)"Error accessing file", (Throwable)ioe);
                }
            }
        }
        return message;
    }
}

