/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb.actions;

import org.jboss.internal.soa.esb.assertion.AssertArgument;

public class AggregationDetails {
    private String seriesUuid;
    private int messageNumber;
    private int seriesSize;
    private long seriesTimestamp;
    private String splitId;

    public AggregationDetails(String seriesUuid, int messageNumber, int seriesSize, long seriesTimestamp) {
        this.messageNumber = -1;
        this.seriesSize = -1;
        this.seriesTimestamp = -1L;
        AssertArgument.isNotNullAndNotEmpty(seriesUuid, "seriesUuid");
        if (messageNumber < 1) {
            throw new IllegalArgumentException("Invalid AggregatorDetails.  messageNumber < 1");
        }
        if (seriesSize < messageNumber) {
            throw new IllegalArgumentException("Invalid AggregatorDetails.  seriesSize < messageNumber");
        }
        if (seriesTimestamp < 1L) {
            throw new IllegalArgumentException("Invalid AggregatorDetails.  timestamp < 1");
        }
        this.seriesUuid = seriesUuid;
        this.messageNumber = messageNumber;
        this.seriesSize = seriesSize;
        this.seriesTimestamp = seriesTimestamp;
    }

    public AggregationDetails(String aggregatorTag) {
        block10: {
            this.messageNumber = -1;
            this.seriesSize = -1;
            this.seriesTimestamp = -1L;
            AssertArgument.isNotNullAndNotEmpty(aggregatorTag, "aggregatorTag");
            String[] tokens = aggregatorTag.split(":");
            if (tokens.length < 4) {
                throw new IllegalArgumentException("Invalid Aggregator Tag.  Must have 4 tokens (colon separated).");
            }
            this.seriesUuid = tokens[0];
            if (this.seriesUuid == null || this.seriesUuid.trim().equals("")) {
                throw new IllegalArgumentException("Invalid Aggregator Tag: seriesUuid is blank.");
            }
            try {
                this.messageNumber = Integer.parseInt(tokens[1]);
                if (this.messageNumber < 1) {
                    throw new IllegalArgumentException("Invalid Aggregator Tag.  messageNumber < 1");
                }
                this.seriesSize = Integer.parseInt(tokens[2]);
                if (this.seriesSize < this.messageNumber) {
                    throw new IllegalArgumentException("Invalid Aggregator Tag.  seriesSize < messageNumber");
                }
                this.seriesTimestamp = Long.parseLong(tokens[3]);
                if (this.seriesTimestamp < 1L) {
                    throw new IllegalArgumentException("Invalid Aggregator Tag.  timestamp < 1");
                }
                if (tokens.length == 5) {
                    this.splitId = tokens[4];
                }
            }
            catch (NumberFormatException e) {
                if (this.messageNumber == -1) {
                    throw new IllegalArgumentException("Invalid Aggregator Tag.  'messageNumber' must be an int.");
                }
                if (this.seriesSize == -1) {
                    throw new IllegalArgumentException("Invalid Aggregator Tag.  'seriesSize' must be an int.");
                }
                if (this.seriesTimestamp != -1L) break block10;
                throw new IllegalArgumentException("Invalid Aggregator Tag.  'timestamp' must be an long.");
            }
        }
    }

    public String getSeriesUuid() {
        return this.seriesUuid;
    }

    public int getSeriesSize() {
        return this.seriesSize;
    }

    public int getMessageNumber() {
        return this.messageNumber;
    }

    public long getSeriesTimestamp() {
        return this.seriesTimestamp;
    }

    public String getSplitId() {
        return this.splitId;
    }

    public void setSplitId(String splitId) {
        this.splitId = splitId;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AggregationDetails)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        this.assertDetailsSet();
        if (this.splitId == null) {
            return this.seriesUuid + ":" + this.messageNumber + ":" + this.seriesSize + ":" + this.seriesTimestamp;
        }
        return this.seriesUuid + ":" + this.messageNumber + ":" + this.seriesSize + ":" + this.seriesTimestamp + ":" + this.splitId;
    }

    private void assertDetailsSet() {
        if (this.seriesUuid == null || this.seriesUuid.trim().equals("")) {
            throw new IllegalStateException("AggregationDetails not set: 'seriesUuid' is null or empty.");
        }
        if (this.messageNumber == -1) {
            throw new IllegalStateException("AggregationDetails not set: 'messageNumber' is not set.");
        }
        if (this.seriesSize == -1) {
            throw new IllegalStateException("AggregationDetails not set: 'seriesSize' is not set.");
        }
        if (this.seriesTimestamp == -1L) {
            throw new IllegalStateException("AggregationDetails not set: 'timestamp' is not set.");
        }
    }
}

