/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.soa.esb;

import java.io.Serializable;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.helpers.ConfigTree;

public class Service
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String category;
    private String name;

    public Service(String category, String name) {
        AssertArgument.isNotNullAndNotEmpty(category, "category");
        AssertArgument.isNotNullAndNotEmpty(name, "name");
        this.category = category.trim();
        this.name = name.trim();
    }

    public boolean equals(Service service) {
        return this.category.equals(service.getCategory()) && this.name.equals(service.getName());
    }

    public String getCategory() {
        return this.category;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Service) {
            Service service = (Service)obj;
            if (service.category.equals(this.category) && service.name.equals(this.name)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return (this.category + this.name).hashCode();
    }

    public String toString() {
        return this.category + ":" + this.name;
    }

    public static Service getGatewayTargetService(ConfigTree config) throws ConfigurationException {
        String category = config.getRequiredAttribute("target-service-category");
        String name = config.getRequiredAttribute("target-service-name");
        return new Service(category, name);
    }

    public static Service getService(String category, String name) {
        return category != null && category.trim().length() > 0 && name != null && name.trim().length() > 0 ? new Service(category, name) : null;
    }
}

