/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import java.util.Set;
import javax.management.ObjectName;
import org.jboss.internal.soa.esb.publish.AbstractContractReferencePublisher;
import org.jboss.soa.esb.Service;
import org.jboss.wsf.spi.SPIProvider;
import org.jboss.wsf.spi.SPIProviderResolver;
import org.jboss.wsf.spi.deployment.Endpoint;
import org.jboss.wsf.spi.management.EndpointRegistry;
import org.jboss.wsf.spi.management.EndpointRegistryFactory;

public class ESBServiceContractReferencePublisher
extends AbstractContractReferencePublisher {
    private final String endpointName;
    private String endpointAddress;

    public ESBServiceContractReferencePublisher(Service service, String description, String endpointName) {
        super(service, description);
        this.endpointName = endpointName;
    }

    @Override
    public String getEndpointAddress() {
        if (this.endpointAddress != null) {
            return this.endpointAddress;
        }
        SPIProvider spiProv = SPIProviderResolver.getInstance().getProvider();
        EndpointRegistryFactory factory = (EndpointRegistryFactory)spiProv.getSPI(EndpointRegistryFactory.class);
        EndpointRegistry registry = factory.getEndpointRegistry();
        Set objectNames = registry.getEndpoints();
        for (ObjectName objectName : objectNames) {
            String endpoint = objectName.getKeyProperty("endpoint");
            if (endpoint == null || !endpoint.equals(this.endpointName)) continue;
            Endpoint ep = registry.getEndpoint(objectName);
            this.endpointAddress = ep.getAddress();
            return this.endpointAddress;
        }
        return null;
    }
}

