/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import com.ibm.wsdl.extensions.schema.SchemaImpl;
import com.ibm.wsdl.extensions.soap.SOAPAddressImpl;
import com.ibm.wsdl.extensions.soap.SOAPBindingImpl;
import com.ibm.wsdl.extensions.soap.SOAPBodyImpl;
import com.ibm.wsdl.extensions.soap.SOAPFaultImpl;
import com.ibm.wsdl.extensions.soap.SOAPOperationImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.webservice.ESBServiceEndpointInfo;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.Service;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.jboss.soa.esb.listeners.config.WebserviceInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ESBContractGenerator {
    private static final String SCHEMA_NAMESPACE = "http://www.w3.org/2001/XMLSchema";
    private static final String SCHEMA_NAME = "schema";
    private static final String SCHEMA_PREFIX = "xs";
    private static final String SCHEMA_ELEMENT = "xs:schema";
    private static final String SCHEMA_TARGETNAMESPACE_ATTRIBUTE = "targetNamespace";
    private static final String SCHEMA_VERSION_ATTRIBUTE = "version";
    private static final String SCHEMA_VERSION_VALUE = "1.0";
    private static final String SCHEMA_INCLUDE_ELEMENT = "xs:include";
    private static final String IMPORT_SCHEMA_LOCATION_ATTRIBUTE = "schemaLocation";
    private static final QName XSD_QN = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final String WSDL_NAMESPACE = "http://schemas.xmlsoap.org/wsdl/";
    private static final String WSDL_REQUIRED = "required";
    private static final String WSAW_NAMESPACE = "http://www.w3.org/2006/05/addressing/wsdl";
    private static final String WSAW_PREFIX = "wsaw";
    private static final QName WSAW_ACTION_QN = new QName("http://www.w3.org/2006/05/addressing/wsdl", "Action", "wsaw");
    private static final QName WSAW_USING_ADDRESSING_QN = new QName("http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing", "wsaw");
    private static WSDLFactory wsdlFactory;

    public static String generateWSDL(WebserviceInfo serviceConfig, ESBServiceEndpointInfo serviceInfo, ClassLoader classLoader) throws ConfigurationException {
        QName[] elementNames;
        Definition def = ESBContractGenerator.getWSDLFactory().newDefinition();
        String namespace = serviceInfo.getNamespace();
        def.setTargetNamespace(namespace);
        def.addNamespace("tns", namespace);
        def.addNamespace("soap", "http://schemas.xmlsoap.org/wsdl/soap/");
        if (serviceInfo.isAddressing()) {
            def.getExtensionRegistry().registerSerializer(Binding.class, WSAW_USING_ADDRESSING_QN, (ExtensionSerializer)new UsingAddressingSerializer());
            def.addNamespace(WSAW_PREFIX, WSAW_NAMESPACE);
        }
        Types types = def.createTypes();
        def.setTypes(types);
        HashSet<String> schemasAdded = new HashSet<String>();
        Message reqMessage = null;
        Message resMessage = null;
        ArrayList<Message> faultMessages = null;
        String inXsd = serviceConfig.getInXsd();
        String outXsd = serviceConfig.getOutXsd();
        String faultXsd = serviceConfig.getFaultXsd();
        int nsSuffixCounter = 0;
        if (inXsd != null) {
            if ((elementNames = ESBContractGenerator.getElementNames(inXsd, classLoader, schemasAdded, def, ++nsSuffixCounter)) == null || elementNames.length == 0) {
                throw new ConfigurationException("File defined in inXsd attribute '" + inXsd + "' not found in classpath or contains no elements.");
            }
            reqMessage = ESBContractGenerator.addMessage(def, elementNames[0], serviceInfo.getRequestName(), "in");
        }
        if (outXsd != null) {
            if ((elementNames = ESBContractGenerator.getElementNames(outXsd, classLoader, schemasAdded, def, ++nsSuffixCounter)) == null || elementNames.length == 0) {
                throw new ConfigurationException("File defined in outXsd attribute '" + outXsd + "' not found in classpath or contains no elements.");
            }
            resMessage = ESBContractGenerator.addMessage(def, elementNames[0], serviceInfo.getResponseName(), "out");
        }
        if (faultXsd != null && !serviceInfo.isOneWay()) {
            String[] xsds = faultXsd.split(",");
            faultMessages = new ArrayList<Message>();
            for (String xsd : xsds) {
                QName[] elementNames2;
                if ((elementNames2 = ESBContractGenerator.getElementNames(xsd, classLoader, schemasAdded, def, ++nsSuffixCounter)) == null || elementNames2.length == 0) {
                    throw new ConfigurationException("File defined in faultXsd attribute '" + xsd + "' not found in classpath or contains no elements.");
                }
                ESBContractGenerator.addFaultMessage(faultMessages, def, elementNames2, serviceInfo.getFaultName(), "fault");
            }
        }
        PortType portType = ESBContractGenerator.addPortType(def, serviceInfo, reqMessage, resMessage, faultMessages);
        Binding binding = ESBContractGenerator.addBinding(def, serviceInfo, portType);
        ESBContractGenerator.addService(def, serviceInfo, binding);
        StringWriter sw = new StringWriter();
        try {
            ESBContractGenerator.getWSDLFactory().newWSDLWriter().writeWSDL(def, (Writer)sw);
        }
        catch (WSDLException e) {
            Service service = serviceConfig.getService();
            throw new ConfigurationException("Failed to generate wsdl for service:" + service.getCategory() + "/" + service.getName(), e);
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QName[] getElementNames(String resource, ClassLoader classLoader, Set<String> schemasAdded, Definition def, int nsSuffixCounter) throws ConfigurationException {
        boolean added;
        Document doc;
        String schemaLocation = ESBContractGenerator.getRelativeResource(resource);
        InputStream is = ESBContractGenerator.getResourceAsStream(schemaLocation, classLoader);
        if (is == null) {
            return null;
        }
        try {
            try {
                doc = YADOMUtil.parseStream(is, false, false);
            }
            finally {
                is.close();
            }
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unexpected exception parsing schema resource: " + schemaLocation, ex);
        }
        Element schemaElement = doc.getDocumentElement();
        String targetNamespace = YADOMUtil.getAttribute(schemaElement, SCHEMA_TARGETNAMESPACE_ATTRIBUTE, "");
        try {
            added = ESBContractGenerator.add(schemaElement, schemasAdded);
        }
        catch (Exception ex) {
            throw new ConfigurationException("Unexpected exception adding schema to known resources: " + schemaLocation, ex);
        }
        if (added) {
            if (def.getNamespace(targetNamespace) == null) {
                def.addNamespace("esbns" + nsSuffixCounter, targetNamespace);
            }
            Types types = def.getTypes();
            SchemaImpl schemaImpl = new SchemaImpl();
            Document schemaDoc = YADOMUtil.createDocument();
            Element xsdElement = schemaDoc.createElementNS(SCHEMA_NAMESPACE, SCHEMA_ELEMENT);
            xsdElement.setAttribute(SCHEMA_TARGETNAMESPACE_ATTRIBUTE, targetNamespace);
            xsdElement.setAttribute(SCHEMA_VERSION_ATTRIBUTE, SCHEMA_VERSION_VALUE);
            Element xsdInclude = schemaDoc.createElementNS(SCHEMA_NAMESPACE, SCHEMA_INCLUDE_ELEMENT);
            xsdInclude.setAttribute(IMPORT_SCHEMA_LOCATION_ATTRIBUTE, schemaLocation);
            xsdElement.appendChild(xsdInclude);
            schemaImpl.setElement(xsdElement);
            schemaImpl.setElementType(XSD_QN);
            types.addExtensibilityElement((ExtensibilityElement)schemaImpl);
        }
        NodeList nodes = YADOMUtil.getNodeList(schemaElement, "/schema/element");
        int numNodes = nodes.getLength();
        QName[] result = new QName[numNodes];
        for (int count = 0; count < numNodes; ++count) {
            Node node = nodes.item(count);
            result[count] = new QName(targetNamespace, YADOMUtil.getAttribute((Element)node, "name", ""));
        }
        return result;
    }

    private static String getRelativeResource(String resource) {
        int length = resource.length();
        for (int count = 0; count < length; ++count) {
            if (resource.charAt(count) == '/') continue;
            return resource.substring(count);
        }
        return "";
    }

    private static InputStream getResourceAsStream(String resource, ClassLoader classLoader) {
        if (classLoader != null) {
            return classLoader.getResourceAsStream(resource);
        }
        return null;
    }

    private static boolean add(Element schemaElement, Set<String> schemasAdded) throws SAXException, IOException, TransformerException, ParserConfigurationException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        transformer.transform(new DOMSource(schemaElement), result);
        String newType = writer.toString();
        if (schemasAdded.size() == 0) {
            return schemasAdded.add(newType);
        }
        boolean addSchema = true;
        for (String existingType : schemasAdded) {
            if (!XMLHelper.compareXMLContent(existingType, newType)) continue;
            addSchema = false;
            break;
        }
        if (addSchema) {
            return schemasAdded.add(newType);
        }
        return false;
    }

    private static Message addMessage(Definition def, QName elementName, String msgName, String partName) {
        Message msg = def.createMessage();
        msg.setQName(new QName(def.getTargetNamespace(), msgName));
        msg.setUndefined(false);
        Part part = def.createPart();
        part.setName(partName);
        part.setElementName(elementName);
        msg.addPart(part);
        def.addMessage(msg);
        return msg;
    }

    private static void addFaultMessage(List<Message> faultMessages, Definition def, QName[] elementNames, String msgName, String partName) {
        int numElements = elementNames == null ? 0 : elementNames.length;
        for (int i = 0; i < numElements; ++i) {
            int nameIndex = i + 1;
            Message msg = def.createMessage();
            msg.setQName(new QName(def.getTargetNamespace(), msgName + nameIndex));
            msg.setUndefined(false);
            Part part = def.createPart();
            part.setName(partName + nameIndex);
            part.setElementName(elementNames[i]);
            msg.addPart(part);
            def.addMessage(msg);
            faultMessages.add(msg);
        }
    }

    private static PortType addPortType(Definition def, ESBServiceEndpointInfo serviceInfo, Message inMessage, Message outMessage, List<Message> faultMessages) {
        PortType portType = def.createPortType();
        portType.setQName(new QName(def.getTargetNamespace(), serviceInfo.getPortName()));
        Operation op = def.createOperation();
        op.setUndefined(false);
        op.setName(serviceInfo.getOperationName());
        if (inMessage != null) {
            Input in = def.createInput();
            in.setMessage(inMessage);
            in.setName(inMessage.getQName().getLocalPart());
            if (serviceInfo.isAddressing()) {
                in.setExtensionAttribute(WSAW_ACTION_QN, (Object)serviceInfo.getRequestAction());
            }
            op.setInput(in);
        }
        if (outMessage != null) {
            Output out = def.createOutput();
            out.setMessage(outMessage);
            out.setName(outMessage.getQName().getLocalPart());
            if (serviceInfo.isAddressing()) {
                out.setExtensionAttribute(WSAW_ACTION_QN, (Object)serviceInfo.getResponseAction());
            }
            op.setOutput(out);
        }
        int count = 1;
        if (faultMessages != null) {
            for (Message message : faultMessages) {
                Fault fault = def.createFault();
                fault.setMessage(message);
                fault.setName("fault" + count++);
                op.addFault(fault);
            }
        }
        portType.addOperation(op);
        portType.setUndefined(false);
        def.addPortType(portType);
        return portType;
    }

    private static Binding addBinding(Definition def, ESBServiceEndpointInfo serviceInfo, PortType portType) {
        Map faults;
        SOAPBodyImpl soapBody;
        Binding binding = def.createBinding();
        binding.setUndefined(false);
        binding.setPortType(portType);
        binding.setQName(new QName(def.getTargetNamespace(), serviceInfo.getBindingName()));
        SOAPBindingImpl soapBinding = new SOAPBindingImpl();
        soapBinding.setStyle("document");
        soapBinding.setTransportURI("http://schemas.xmlsoap.org/soap/http");
        binding.addExtensibilityElement((ExtensibilityElement)soapBinding);
        if (serviceInfo.isAddressing()) {
            binding.addExtensibilityElement((ExtensibilityElement)new UsingAddressingExtension());
        }
        BindingOperation bop = def.createBindingOperation();
        bop.setName(serviceInfo.getOperationName());
        Operation op = (Operation)portType.getOperations().get(0);
        bop.setOperation(op);
        SOAPOperationImpl soapOperation = new SOAPOperationImpl();
        soapOperation.setSoapActionURI(serviceInfo.getResponseAction());
        bop.addExtensibilityElement((ExtensibilityElement)soapOperation);
        if (op.getInput() != null) {
            BindingInput binput = def.createBindingInput();
            bop.setBindingInput(binput);
            soapBody = new SOAPBodyImpl();
            soapBody.setUse("literal");
            binput.setName(serviceInfo.getRequestName());
            binput.addExtensibilityElement((ExtensibilityElement)soapBody);
        }
        if (op.getOutput() != null) {
            BindingOutput boutput = def.createBindingOutput();
            bop.setBindingOutput(boutput);
            soapBody = new SOAPBodyImpl();
            soapBody.setUse("literal");
            boutput.setName(serviceInfo.getResponseName());
            boutput.addExtensibilityElement((ExtensibilityElement)soapBody);
        }
        if ((faults = op.getFaults()) != null) {
            for (Fault fault : op.getFaults().values()) {
                BindingFault bfault = def.createBindingFault();
                bfault.setName(fault.getName());
                bop.addBindingFault(bfault);
                SOAPFaultImpl soapFault = new SOAPFaultImpl();
                soapFault.setName(fault.getName());
                soapFault.setUse("literal");
                bfault.addExtensibilityElement((ExtensibilityElement)soapFault);
            }
        }
        binding.addBindingOperation(bop);
        def.addBinding(binding);
        return binding;
    }

    private static void addService(Definition def, ESBServiceEndpointInfo serviceInfo, Binding binding) {
        javax.wsdl.Service service = def.createService();
        service.setQName(new QName(def.getTargetNamespace(), serviceInfo.getServiceName()));
        Port port = def.createPort();
        port.setBinding(binding);
        port.setName(serviceInfo.getPortName());
        SOAPAddressImpl soapAddress = new SOAPAddressImpl();
        soapAddress.setLocationURI("http://change_this_URI/" + serviceInfo.getServletPath());
        port.addExtensibilityElement((ExtensibilityElement)soapAddress);
        service.addPort(port);
        def.addService(service);
    }

    private static synchronized WSDLFactory getWSDLFactory() throws ConfigurationException {
        if (wsdlFactory == null) {
            try {
                wsdlFactory = AccessController.doPrivileged(new PrivilegedExceptionAction<WSDLFactory>(){

                    @Override
                    public WSDLFactory run() throws WSDLException {
                        return WSDLFactory.newInstance();
                    }
                });
            }
            catch (PrivilegedActionException pae) {
                throw new ConfigurationException("Failed to instantiate the WSDL factory", pae.getCause());
            }
        }
        return wsdlFactory;
    }

    private static class UsingAddressingSerializer
    implements ExtensionSerializer {
        private UsingAddressingSerializer() {
        }

        public void marshall(Class parentType, QName elementType, ExtensibilityElement extension, PrintWriter pw, Definition definition, ExtensionRegistry registry) throws WSDLException {
            if (extension != null) {
                String prefix = definition.getPrefix(elementType.getNamespaceURI());
                pw.print("    <" + prefix + ":" + elementType.getLocalPart());
                if (extension.getRequired().booleanValue()) {
                    String wsdlPrefix = definition.getPrefix(ESBContractGenerator.WSDL_NAMESPACE);
                    pw.print(" " + wsdlPrefix + ":" + ESBContractGenerator.WSDL_REQUIRED + "=\"true\"");
                }
                pw.println("/>");
            }
        }
    }

    private static class UsingAddressingExtension
    implements ExtensibilityElement {
        private UsingAddressingExtension() {
        }

        public QName getElementType() {
            return WSAW_USING_ADDRESSING_QN;
        }

        public Boolean getRequired() {
            return Boolean.TRUE;
        }

        public void setElementType(QName qname) {
        }

        public void setRequired(Boolean required) {
        }
    }
}

