/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.webservice;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.io.ByteArrayInputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.Detail;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Provider;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.Relationship;
import javax.xml.ws.addressing.soap.SOAPAddressingProperties;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.webservice.AddressingContext;
import org.jboss.soa.esb.client.ServiceInvoker;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.couriers.FaultMessageException;
import org.jboss.soa.esb.listeners.message.MessageDeliverException;
import org.jboss.soa.esb.message.Body;
import org.jboss.soa.esb.message.Message;
import org.jboss.soa.esb.message.MessagePayloadProxy;
import org.jboss.soa.esb.message.Properties;
import org.jboss.soa.esb.message.format.MessageFactory;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.auth.ExtractionException;
import org.jboss.soa.esb.services.security.auth.ExtractorUtil;
import org.jboss.soa.esb.services.security.auth.SecurityInfoExtractor;
import org.jboss.soa.esb.services.security.auth.ws.SamlSoapAssertionExtractor;
import org.jboss.soa.esb.services.security.auth.ws.WSSecuritySoapExtractor;
import org.w3c.dom.Document;

public abstract class BaseWebService
implements Provider<SOAPMessage> {
    private static final QName SERVER_FAULT_QN = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Server");
    private static final boolean RETURN_STACK_TRACES;
    private static final Logger LOGGER;
    private static final javax.xml.soap.MessageFactory SOAP_MESSAGE_FACTORY;
    private static final AddressingBuilder ADDRESSING_BUILDER;
    private static final String ADDRESSING_NAMESPACE;
    private static final QName ADDRESSING_REPLY;
    private static final Set<SecurityInfoExtractor<SOAPMessage>> extractors;
    protected final ServiceInvoker serviceInvoker;
    protected final MessagePayloadProxy requestProxy;
    protected final MessagePayloadProxy responseProxy;
    protected final String action;

    protected BaseWebService(ServiceInvoker serviceInvoker, String requestLocation, String responseLocation, String action) throws MessageDeliverException {
        this.serviceInvoker = serviceInvoker;
        this.requestProxy = new MessagePayloadProxy(null, requestLocation);
        this.responseProxy = new MessagePayloadProxy(responseLocation, null);
        this.action = action;
    }

    public SOAPMessage invoke(SOAPMessage request) {
        if (SOAP_MESSAGE_FACTORY == null) {
            throw new WebServiceException("Failed to instantiate SOAP Message Factory");
        }
        SOAPAddressingProperties soapIncomingProps = AddressingContext.getAddressingProperties();
        Message esbReq = MessageFactory.getInstance().getMessage();
        try {
            SOAPBody soapBody = request.getSOAPBody();
            if (soapBody == null) {
                throw new WebServiceException("Missing SOAP body from request");
            }
            Iterator children = soapBody.getChildElements();
            boolean found = false;
            while (children.hasNext()) {
                Node node = (Node)children.next();
                if (!(node instanceof SOAPElement)) continue;
                if (found) {
                    throw new SOAPException("Found multiple SOAPElements in SOAPBody");
                }
                StringWriter sw = new StringWriter();
                XMLEventWriter writer = XMLHelper.getXMLEventWriter(new StreamResult(sw));
                XMLHelper.readDomNode((org.w3c.dom.Node)node, writer, true);
                this.requestProxy.setPayload(esbReq, sw.toString());
                found = true;
            }
            if (!found) {
                throw new SOAPException("Could not find SOAPElement in SOAPBody");
            }
            if (soapIncomingProps != null) {
                this.initialiseWSAProps(esbReq, soapIncomingProps);
            }
            AuthenticationRequest authRequest = this.extractSecurityDetails(request, esbReq);
            ExtractorUtil.addAuthRequestToMessage(authRequest, esbReq);
            Message esbRes = this.deliverMessage(esbReq);
            SOAPMessage response = SOAP_MESSAGE_FACTORY.createMessage();
            if (esbRes != null) {
                Object input = this.responseProxy.getPayload(esbRes);
                if (input == null) {
                    throw new SOAPException("Null response from service");
                }
                String soapRes = input.toString();
                Document root = BaseWebService.parseAsDom(soapRes);
                response.getSOAPBody().addDocument(root);
            }
            if (soapIncomingProps == null) {
                AddressingContext.setAddressingProperties(null);
            } else {
                SOAPAddressingProperties soapOutgoingProps = (SOAPAddressingProperties)ADDRESSING_BUILDER.newAddressingProperties();
                if (this.action != null) {
                    soapOutgoingProps.setAction(ADDRESSING_BUILDER.newURI(this.action));
                }
                AddressingContext.setAddressingProperties(soapOutgoingProps);
            }
            return response;
        }
        catch (WebServiceException wse) {
            throw wse;
        }
        catch (Exception ex) {
            try {
                FaultMessageException fme;
                Message faultMessage;
                SOAPMessage faultMsg = null;
                if (ex instanceof FaultMessageException && (faultMessage = (fme = (FaultMessageException)ex).getReturnedMessage()) != null) {
                    Body body = faultMessage.getBody();
                    QName faultCode = (QName)body.get("org.jboss.soa.esb.message.fault.detail.code");
                    String faultDescription = (String)body.get("org.jboss.soa.esb.message.fault.detail.description");
                    String faultDetail = (String)body.get("org.jboss.soa.esb.message.fault.detail.detail");
                    if (faultCode != null) {
                        faultMsg = SOAP_MESSAGE_FACTORY.createMessage();
                        SOAPFault fault = faultMsg.getSOAPBody().addFault(faultCode, faultDescription);
                        if (faultDetail != null) {
                            try {
                                Document detailDoc = BaseWebService.parseAsDom(faultDetail);
                                Detail detail = fault.addDetail();
                                detail.appendChild((org.w3c.dom.Node)detailDoc.getDocumentElement());
                            }
                            catch (Exception ex2) {
                                LOGGER.warn((Object)"Failed to parse fault detail", (Throwable)ex2);
                            }
                        }
                    } else {
                        Throwable cause = fme.getCause();
                        SOAPMessage sOAPMessage = faultMsg = cause != null ? this.generateFault(cause) : this.generateFault(ex);
                    }
                }
                if (faultMsg == null) {
                    faultMsg = this.generateFault(ex);
                }
                return faultMsg;
            }
            catch (SOAPException soape) {
                throw new WebServiceException("Unexpected exception generating fault response", (Throwable)soape);
            }
        }
    }

    private static Document parseAsDom(String soapRes) throws ParserConfigurationException, XMLStreamException {
        XMLEventReader reader = XMLHelper.getXMLEventReader(new ByteArrayInputStream(soapRes.getBytes()));
        return XMLHelper.createDocument(reader);
    }

    protected AuthenticationRequest extractSecurityDetails(SOAPMessage request, Message esbReq) throws SecurityServiceException {
        try {
            return ExtractorUtil.extract(request, extractors);
        }
        catch (ExtractionException e) {
            throw new SecurityServiceException(e.getMessage(), e);
        }
    }

    private SOAPMessage generateFault(Throwable th) throws SOAPException {
        SOAPMessage faultMsg = SOAP_MESSAGE_FACTORY.createMessage();
        if (RETURN_STACK_TRACES) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            th.printStackTrace(pw);
            pw.flush();
            pw.close();
            faultMsg.getSOAPBody().addFault(SERVER_FAULT_QN, sw.toString());
        } else {
            faultMsg.getSOAPBody().addFault(SERVER_FAULT_QN, th.getMessage());
        }
        return faultMsg;
    }

    private void initialiseWSAProps(Message esbReq, SOAPAddressingProperties props) {
        Relationship[] relationships;
        int numRelatesTo;
        AttributedURI messageID = props.getMessageID();
        Properties esbReqProps = esbReq.getProperties();
        if (messageID != null) {
            esbReqProps.setProperty("org.jboss.soa.esb.gateway.ebws.messageID", messageID.getURI().toASCIIString());
        }
        int n = numRelatesTo = (relationships = props.getRelatesTo()) == null ? 0 : relationships.length;
        if (numRelatesTo > 0) {
            ArrayList<String> relatesTo = new ArrayList<String>();
            ArrayList<String> relationshipType = new ArrayList<String>();
            for (int count = 0; count < numRelatesTo; ++count) {
                Relationship relationship = relationships[count];
                if (relationship == null) continue;
                relatesTo.add(relationship.getID().toASCIIString());
                QName type = relationship.getType();
                if (type != null) {
                    relationshipType.add(type.toString());
                    continue;
                }
                relationshipType.add(ADDRESSING_REPLY.toString());
            }
            if (relatesTo.size() > 0) {
                esbReqProps.setProperty("org.jboss.soa.esb.gateway.ebws.relatesTo", relatesTo.toArray(new String[relatesTo.size()]));
                esbReqProps.setProperty("org.jboss.soa.esb.gateway.ebws.relationshipType", relationshipType.toArray(new String[relationshipType.size()]));
            }
        }
    }

    protected abstract Message deliverMessage(Message var1) throws Exception;

    static {
        LOGGER = Logger.getLogger(BaseWebService.class);
        ADDRESSING_BUILDER = AddressingBuilder.getAddressingBuilder();
        ADDRESSING_NAMESPACE = ADDRESSING_BUILDER.getNamespaceURI();
        ADDRESSING_REPLY = new QName(ADDRESSING_NAMESPACE, "Reply");
        extractors = new LinkedHashSet<SecurityInfoExtractor<SOAPMessage>>();
        extractors.add(new WSSecuritySoapExtractor());
        extractors.add(new SamlSoapAssertionExtractor());
        PropertyManager propertyManager = ModulePropertyManager.getPropertyManager("transports");
        String returnStackTraces = propertyManager.getProperty("org.jboss.soa.esb.ws.returnStackTrace");
        RETURN_STACK_TRACES = Boolean.parseBoolean(returnStackTraces);
        javax.xml.soap.MessageFactory soapMessageFactory = null;
        try {
            soapMessageFactory = javax.xml.soap.MessageFactory.newInstance();
        }
        catch (SOAPException soape) {
            LOGGER.error((Object)"Could not instantiate SOAP Message Factory", (Throwable)soape);
        }
        SOAP_MESSAGE_FACTORY = soapMessageFactory;
    }
}

