/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.util.ClassUtil;

public class StreamUtils {
    private static Logger logger = Logger.getLogger(StreamUtils.class);

    public static byte[] readStream(InputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null 'stream' arg passed in method call.");
        }
        ByteArrayOutputStream outBuffer = new ByteArrayOutputStream();
        byte[] buffer = new byte[256];
        int readCount = 0;
        try {
            while ((readCount = stream.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading stream.", e);
        }
        return outBuffer.toByteArray();
    }

    public static String readReader(Reader reader) {
        if (reader == null) {
            throw new IllegalArgumentException("null 'reader' arg passed in method call.");
        }
        StringWriter outBuffer = new StringWriter();
        char[] buffer = new char[256];
        int readCount = 0;
        try {
            while ((readCount = reader.read(buffer)) != -1) {
                outBuffer.write(buffer, 0, readCount);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading reader.", e);
        }
        return outBuffer.toString();
    }

    public static String readStreamString(InputStream stream, String charset) throws UnsupportedEncodingException {
        return new String(StreamUtils.readStream(stream), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getResourceAsString(String resource, String charset) throws ConfigurationException, UnsupportedEncodingException {
        InputStream stream = StreamUtils.getResource(resource);
        try {
            String string = StreamUtils.readStreamString(stream, charset);
            return string;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)("Error closing resource stream '" + resource + "'."), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getResourceAsBytes(String resource) throws ConfigurationException {
        InputStream stream = StreamUtils.getResource(resource);
        try {
            byte[] byArray = StreamUtils.readStream(stream);
            return byArray;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                logger.error((Object)("Error closing resource stream '" + resource + "'."), (Throwable)e);
            }
        }
    }

    public static InputStream getResource(String resource) throws ConfigurationException {
        return StreamUtils.getResource(resource, StreamUtils.class);
    }

    public static InputStream getResource(String resource, Class<?> caller) throws ConfigurationException {
        try {
            File file = new File(resource);
            if (file.exists() && !file.isDirectory()) {
                return new FileInputStream(file);
            }
            InputStream stream = ClassUtil.getResourceAsStream(resource, caller);
            if (stream != null) {
                return stream;
            }
            try {
                URI fileURI = new URI(resource);
                if (fileURI.isAbsolute()) {
                    return fileURI.toURL().openStream();
                }
            }
            catch (URISyntaxException e) {
                throw new ConfigurationException("Failed to load resource '" + resource + "'.");
            }
        }
        catch (IOException e) {
            throw new ConfigurationException("Failed to load resource '" + resource + "'.", e);
        }
        throw new ConfigurationException("Failed to locate resource '" + resource + "'.");
    }
}

