/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class PropertiesHelper {
    private static final String IDENTITY_TRANSFORM = "<xsl:stylesheet xmlns:xsl='http://www.w3.org/1999/XSL/Transform' version='1.0'>  <xsl:output method='xml' doctype-system='http://java.sun.com/dtd/properties.dtd'/>  <xsl:template match='/'>    <xsl:apply-templates/>  </xsl:template>  <xsl:template match='*|@*'>    <xsl:copy>      <xsl:apply-templates select='@*|node()'/>    </xsl:copy>  </xsl:template></xsl:stylesheet>";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties translateXMLToText(File xmlPropertyFile, File propertyFile, String propertyFileComments) throws IOException {
        FileInputStream fis = new FileInputStream(xmlPropertyFile);
        try {
            Properties properties;
            FileOutputStream fos = new FileOutputStream(propertyFile);
            try {
                properties = PropertiesHelper.translateXMLToText(fis, fos, propertyFileComments);
            }
            catch (Throwable throwable) {
                fos.close();
                throw throwable;
            }
            fos.close();
            return properties;
        }
        finally {
            fis.close();
        }
    }

    public static Properties translateXMLToText(InputStream xmlPropertyInputStream, OutputStream propertyOutputStream, String propertyFileComments) throws IOException {
        Transformer transformer;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        StreamSource identitySource = new StreamSource(new StringReader(IDENTITY_TRANSFORM));
        try {
            transformer = transformerFactory.newTransformer(identitySource);
        }
        catch (TransformerConfigurationException tce) {
            IOException ioe = new IOException("Failed to configure identity transformation");
            ioe.initCause(tce);
            throw ioe;
        }
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        try {
            transformer.transform(new StreamSource(xmlPropertyInputStream), new StreamResult(result));
        }
        catch (TransformerException te) {
            IOException ioe = new IOException("Failed to evaluate the identity transformation");
            ioe.initCause(te);
            throw ioe;
        }
        Properties xmlProperties = new Properties();
        ByteArrayInputStream bais = new ByteArrayInputStream(result.toByteArray());
        xmlProperties.loadFromXML(bais);
        BufferedOutputStream bos = new BufferedOutputStream(propertyOutputStream);
        xmlProperties.store(bos, propertyFileComments);
        bos.flush();
        return xmlProperties;
    }
}

