/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.util.ArrayList;
import java.util.List;
import org.jboss.internal.soa.esb.util.Element;
import org.jboss.internal.soa.esb.util.Text;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class IdentitySAXHandler
extends DefaultHandler {
    private Element rootElement;
    private Element currentElement;
    private List<Element> stack = new ArrayList<Element>();
    private StringBuilder currentText = new StringBuilder();

    @Override
    public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
        this.checkText();
        Element element = new Element(uri, localName, attributes);
        if (this.rootElement == null) {
            this.rootElement = element;
        }
        if (this.currentElement != null) {
            this.currentElement.addChild(element);
            this.stack.add(this.currentElement);
        }
        this.currentElement = element;
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        this.checkText();
        int lastIndex = this.stack.size() - 1;
        this.currentElement = lastIndex < 0 ? null : this.stack.remove(lastIndex);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.currentText.append(ch, start, length);
    }

    private void checkText() {
        int textLength = this.currentText.length();
        if (textLength > 0) {
            int end;
            int start;
            for (start = 0; start < textLength && this.isXMLWhitespace(this.currentText.charAt(start)); ++start) {
            }
            for (end = textLength - 1; end >= start && this.isXMLWhitespace(this.currentText.charAt(end)); --end) {
            }
            if (start <= end) {
                this.currentElement.addChild(new Text(this.currentText.substring(start, end + 1)));
            }
            this.currentText.setLength(0);
            this.currentText.trimToSize();
        }
    }

    private boolean isXMLWhitespace(char ch) {
        return ch == ' ' || ch == '\t' || ch == '\r' || ch == '\n';
    }

    public Element getRootElement() {
        return this.rootElement;
    }
}

