/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.util.FtpUtils;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.addressing.eprs.FTPEpr;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.helpers.ConfigTree;
import org.jboss.soa.esb.helpers.KeyValuePair;
import org.jboss.soa.esb.util.FileUtil;
import org.jboss.soa.esb.util.FtpClientUtil;
import org.jboss.soa.esb.util.RemoteFileSystem;
import org.jboss.soa.esb.util.RemoteFileSystemException;

public class FtpImpl
implements RemoteFileSystem {
    private static final Logger _logger = Logger.getLogger(FtpImpl.class);
    private static final String TMP_SUFFIX = ".rosettaPart";
    private boolean m_bPassive;
    private int m_iPort;
    private int _timeout = 0;
    protected FTPClient m_oConn;
    private FTPEpr m_oEpr;
    protected ConfigTree m_oParms;
    private String m_sFtpServer;
    private String m_sUser;
    private String m_sPasswd;
    private String m_sRemoteDir;
    private String m_sLocalDir;
    private int renameRetry;

    public FtpImpl(ConfigTree p_oP, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        this.m_oParms = p_oP;
        this.initialize(p_bConnect);
    }

    public FtpImpl(FTPEpr p_oP, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        this(p_oP);
        this.configTreeFromEpr();
        this.initialize(p_bConnect);
    }

    public FtpImpl(FTPEpr p_oP) throws ConfigurationException {
        URI uri;
        this.m_oEpr = p_oP;
        try {
            uri = this.m_oEpr.getURI();
        }
        catch (URISyntaxException e) {
            throw new ConfigurationException(e);
        }
        this.m_sFtpServer = uri.getHost();
        String[] sa = null;
        if (uri.getUserInfo() != null) {
            sa = uri.getUserInfo().split(":");
        }
        int saLen = sa == null ? 0 : sa.length;
        switch (saLen) {
            case 2: {
                this.m_sPasswd = sa[1];
            }
            case 1: {
                this.m_sUser = sa[0];
            }
        }
        this.m_sRemoteDir = uri.getPath();
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (this.m_sRemoteDir == null || this.m_sRemoteDir.equals("")) {
            this.m_sRemoteDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.remotedir", tmpdir);
        }
        this.m_iPort = uri.getPort();
        this.m_sLocalDir = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.localdir", tmpdir);
        File oLocalDir = new File(this.m_sLocalDir);
        if (!oLocalDir.exists()) {
            throw new ConfigurationException("Local FTP directory '" + oLocalDir.getAbsolutePath() + "' doesn't exist.  Check your JBossESB config '" + "transports" + ":" + "org.jboss.soa.esb.ftp.localdir" + "'");
        }
        this.m_bPassive = this.m_oEpr.getPassive();
        String timeout = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.timeout", null);
        if (timeout != null) {
            try {
                this._timeout = Integer.parseInt(timeout);
            }
            catch (NumberFormatException ex) {
                throw new ConfigurationException("Invalid timeout specified.", ex);
            }
        } else {
            this._timeout = 0;
        }
    }

    public FtpImpl(List<KeyValuePair> p_oAttribs, boolean p_bConnect) throws ConfigurationException, RemoteFileSystemException {
        this.m_oParms = new ConfigTree("fromProps");
        for (KeyValuePair oCurr : p_oAttribs) {
            this.m_oParms.setAttribute(oCurr.getKey(), oCurr.getValue());
        }
        this.initialize(p_bConnect);
    }

    protected void checkParms() throws ConfigurationException {
        String att = this.m_oParms.getAttribute("URL");
        URI uri = null;
        try {
            if (att != null) {
                uri = new URI(att);
            }
        }
        catch (URISyntaxException ex) {
            throw new ConfigurationException(ex);
        }
        String string = this.m_sFtpServer = null != uri ? uri.getHost() : this.m_oParms.getAttribute("ftpServer");
        if (null == this.m_sFtpServer) {
            throw new ConfigurationException("No FTP server specified");
        }
        String[] sa = null == uri ? null : uri.getUserInfo().split(":");
        String string2 = this.m_sUser = null != sa ? sa[0] : this.m_oParms.getAttribute("ftpUser");
        if (null == this.m_sUser) {
            throw new ConfigurationException("No username specified for FTP");
        }
        this.m_sPasswd = null != sa && sa.length > 1 ? sa[1] : this.m_oParms.getAttribute("ftpPassword");
        String string3 = this.m_sRemoteDir = null != uri ? uri.getPath() : this.m_oParms.getAttribute("ftpRemoteDir");
        if (null == this.m_sRemoteDir) {
            this.m_sRemoteDir = "";
        }
        this.m_sLocalDir = this.m_oParms.getAttribute("ftpLocalDir");
        if (null == this.m_sLocalDir) {
            this.m_sLocalDir = ".";
        }
        String sAux = this.m_oParms.getAttribute("ftpPort");
        this.m_iPort = null != uri ? uri.getPort() : (null == sAux ? 21 : Integer.parseInt(sAux));
        this.m_bPassive = false;
        sAux = this.m_oParms.getAttribute("ftpPassive");
        this.m_bPassive = null != sAux && Boolean.parseBoolean(sAux);
        String renameRetryString = ModulePropertyManager.getPropertyManager("transports").getProperty("org.jboss.soa.esb.ftp.renameretry", null);
        if (renameRetryString != null) {
            try {
                this.renameRetry = Integer.parseInt(renameRetryString);
            }
            catch (Exception ex) {
                throw new ConfigurationException("Invalid rename retry limit: " + renameRetryString);
            }
        } else {
            this.renameRetry = 10;
        }
        if (this.renameRetry < 1) {
            this.renameRetry = 1;
        }
    }

    protected void configTreeFromEpr() throws RemoteFileSystemException {
        this.m_oParms = new ConfigTree("fromEpr");
        try {
            this.m_oParms.setAttribute("ftpServer", this.m_sFtpServer);
            this.m_oParms.setAttribute("ftpUser", this.m_sUser);
            if (this.m_sPasswd != null) {
                this.m_oParms.setAttribute("ftpPassword", this.m_sPasswd);
            }
            this.m_oParms.setAttribute("ftpRemoteDir", this.m_sRemoteDir);
            if (this.m_iPort > 0) {
                this.m_oParms.setAttribute("ftpPort", Integer.toString(this.m_iPort));
            }
            this.m_oParms.setAttribute("ftpLocalDir", this.m_sLocalDir);
            this.m_oParms.setAttribute("ftpAscii", Boolean.toString(false));
            this.m_oParms.setAttribute("ftpPassive", Boolean.toString(this.m_bPassive));
        }
        catch (Exception e) {
            throw new RemoteFileSystemException(e);
        }
    }

    @Override
    public void deleteRemoteFile(String p_sFile) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.deleteFile(p_sFile)) {
                throw new RemoteFileSystemException("Failed to delete remote file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void downloadFile(String p_sFile, String p_sFinalName) throws IOException, RemoteFileSystemException {
        try {
            File toTmp;
            File oNewTmp;
            File oNew;
            File to = new File(p_sFinalName);
            File oLocalDir = new File(this.m_sLocalDir);
            File file = oNew = to.isAbsolute() ? to : new File(oLocalDir, p_sFinalName);
            if (oNew.exists()) {
                oNew.delete();
            }
            File file2 = oNewTmp = (toTmp = new File(p_sFinalName + TMP_SUFFIX)).isAbsolute() ? toTmp : new File(oLocalDir, p_sFinalName + TMP_SUFFIX);
            if (oNewTmp.exists()) {
                oNewTmp.delete();
            }
            this.changeRemoteDirectory();
            InputStream is = this.m_oConn.retrieveFileStream(p_sFile);
            if (is == null) {
                throw new RemoteFileSystemException("Could not download file: " + this.m_oConn.getReplyString());
            }
            try {
                FileOutputStream fos = new FileOutputStream(oNewTmp);
                try {
                    this.copyStream(is, fos);
                }
                finally {
                    fos.close();
                }
            }
            finally {
                is.close();
            }
            if (!this.m_oConn.completePendingCommand()) {
                oNewTmp.delete();
                throw new RemoteFileSystemException("Failed to download contents: " + this.m_oConn.getReplyString());
            }
            FileUtil.renameTo(oNewTmp, oNew);
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    @Override
    public String[] getFileListFromRemoteDir(String p_sSuffix) throws RemoteFileSystemException, IOException {
        String sSuffix = null == p_sSuffix ? "*" : "*" + p_sSuffix;
        try {
            this.changeRemoteDirectory();
            return this.m_oConn.listNames(sSuffix);
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    @Override
    public String getRemoteDir() {
        return this.m_sRemoteDir;
    }

    protected void initialize(boolean bConnect) throws ConfigurationException, RemoteFileSystemException {
        this.checkParms();
        this.m_oConn = this.instantiateClient();
        if (bConnect) {
            try {
                this.connect();
                if (!this.m_oConn.isConnected()) {
                    throw new RemoteFileSystemException("Can't connect to FTP server");
                }
                if (!this.m_oConn.login(this.m_sUser, this.m_sPasswd)) {
                    this.m_oConn.logout();
                    throw new RemoteFileSystemException("Remote login failed: " + this.m_oConn.getReplyString());
                }
                this.m_oConn.setFileType(2);
                if (this.m_bPassive) {
                    this.m_oConn.enterLocalPassiveMode();
                }
                if (this._timeout > 0) {
                    this.m_oConn.setDataTimeout(this._timeout);
                }
            }
            catch (IOException ioe) {
                if (this.m_oConn.isConnected()) {
                    try {
                        this.m_oConn.disconnect();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                throw new RemoteFileSystemException(ioe);
            }
        }
    }

    protected FTPClient instantiateClient() throws RemoteFileSystemException {
        return new FTPClient();
    }

    protected void connect() throws IOException {
        if (this.m_iPort > 0) {
            this.m_oConn.connect(this.m_sFtpServer, this.m_iPort);
        } else {
            this.m_oConn.connect(this.m_sFtpServer);
        }
    }

    @Override
    public void quit() {
        if (null != this.m_oConn) {
            try {
                this.m_oConn.quit();
                this.m_oConn.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void remoteDelete(File p_oFile) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.deleteFile(p_oFile.getName())) {
                throw new RemoteFileSystemException("Failed to delete remote file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    @Override
    public void remoteRename(File p_oFrom, File p_oTo) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.rename(FtpClientUtil.fileToFtpString(p_oFrom), FtpUtils.fileToFtpString(p_oTo))) {
                throw new RemoteFileSystemException("Failed to rename file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    @Override
    public void renameInRemoteDir(String p_sFrom, String p_sTo) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            if (!this.m_oConn.rename(p_sFrom, p_sTo)) {
                throw new RemoteFileSystemException("Failed to rename file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    @Override
    public void setRemoteDir(String p_sDir) throws RemoteFileSystemException {
        if (p_sDir == null) {
            throw new IllegalArgumentException();
        }
        this.m_sRemoteDir = p_sDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadFile(File p_oFile, String p_sRemoteName) throws RemoteFileSystemException {
        try {
            this.changeRemoteDirectory();
            String sRemoteTmp = p_sRemoteName + TMP_SUFFIX;
            OutputStream os = this.m_oConn.storeFileStream(sRemoteTmp);
            if (os == null) {
                throw new RemoteFileSystemException("Failed to obtain output stream: " + this.m_oConn.getReplyString());
            }
            try {
                FileInputStream fis = new FileInputStream(p_oFile);
                try {
                    this.copyStream(fis, os);
                }
                finally {
                    fis.close();
                }
            }
            finally {
                os.flush();
                os.close();
            }
            if (!this.m_oConn.completePendingCommand()) {
                throw new RemoteFileSystemException("Failed to upload contents: " + this.m_oConn.getReplyString());
            }
            boolean retryProblem = true;
            for (int i = 0; i < this.renameRetry; ++i) {
                if (this.m_oConn.rename(sRemoteTmp, p_sRemoteName)) {
                    retryProblem = false;
                    break;
                }
                if (i + 1 >= this.renameRetry) continue;
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            if (retryProblem) {
                throw new RemoteFileSystemException("Failed to rename file: " + this.m_oConn.getReplyString());
            }
        }
        catch (IOException ioe) {
            throw new RemoteFileSystemException(ioe);
        }
    }

    private void changeRemoteDirectory() throws IOException, RemoteFileSystemException {
        String remoteDir = this.getRemoteDir();
        if (remoteDir != null && remoteDir.length() > 0 && !this.m_oConn.changeWorkingDirectory(remoteDir)) {
            throw new RemoteFileSystemException("Failed to change to remote directory: " + this.m_oConn.getReplyString());
        }
    }

    private void copyStream(InputStream is, OutputStream os) throws IOException {
        int count;
        BufferedInputStream bis = new BufferedInputStream(is);
        BufferedOutputStream bos = new BufferedOutputStream(os);
        byte[] buffer = new byte[256];
        while ((count = bis.read(buffer)) > 0) {
            bos.write(buffer, 0, count);
        }
        bos.flush();
    }
}

