/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class Exit {
    private static Logger logger = Logger.getLogger(Exit.class);
    private static final String EXIT = "Exit";

    public static void startListener(final int port) throws Exception {
        new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ServerSocket serverSocket = null;
                try {
                    serverSocket = new ServerSocket(port);
                    logger.info((Object)("Started Exit listener on port " + port));
                    while (true) {
                        Socket socket = serverSocket.accept();
                        OutputStream output = socket.getOutputStream();
                        InputStream input = socket.getInputStream();
                        try {
                            Exit.writeExit(output);
                            if (!Exit.isExit(input)) continue;
                            logger.info((Object)("Received process exit event on port " + port));
                        }
                        finally {
                            Exit.closeSocket(output, input, socket);
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException e) {
                    System.err.println(e);
                    System.exit(1);
                    return;
                }
                finally {
                    if (serverSocket != null) {
                        try {
                            serverSocket.close();
                        }
                        catch (IOException e) {
                            System.err.println(e);
                        }
                    }
                }
                System.exit(0);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signalExit(int port) throws Throwable {
        Socket socket = new Socket("localhost", port);
        OutputStream output = socket.getOutputStream();
        InputStream input = socket.getInputStream();
        try {
            if (Exit.isExit(input)) {
                Exit.writeExit(output);
            }
        }
        finally {
            Exit.closeSocket(output, input, socket);
        }
    }

    private static boolean isExit(InputStream input) {
        try {
            DataInputStream dataReader = new DataInputStream(input);
            return EXIT.equals(dataReader.readUTF());
        }
        catch (Exception e) {
            return false;
        }
    }

    private static void writeExit(OutputStream output) {
        try {
            DataOutputStream dataWriter = new DataOutputStream(output);
            dataWriter.writeUTF(EXIT);
            dataWriter.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void closeSocket(OutputStream output, InputStream input, Socket socket) throws IOException {
        try {
            output.close();
        }
        finally {
            try {
                input.close();
            }
            finally {
                socket.close();
            }
        }
    }
}

