/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.util;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.namespace.QName;
import org.jboss.internal.soa.esb.util.Node;
import org.xml.sax.Attributes;

public class Element
implements Node {
    private static final Comparator<QName> QNAME_COMPARATOR = new QNameComparator();
    private final QName name;
    private final Map<QName, String> attributes = new TreeMap<QName, String>(QNAME_COMPARATOR);
    private final List<Node> children = new ArrayList<Node>();

    Element(String namespaceURI, String localName, Attributes attributes) {
        this.name = new QName(namespaceURI, localName);
        int numAttributes = attributes.getLength();
        for (int count = 0; count < numAttributes; ++count) {
            String attrNamespaceURI = attributes.getURI(count);
            String attrLocalName = attributes.getLocalName(count);
            String attrValue = attributes.getValue(count);
            this.attributes.put(new QName(attrNamespaceURI, attrLocalName), attrValue);
        }
    }

    void addChild(Node child) {
        this.children.add(child);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj instanceof Element) {
            Element rhs = (Element)obj;
            return this.name.equals(rhs.name) && ((Object)this.attributes).equals(rhs.attributes) && ((Object)this.children).equals(rhs.children);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode() ^ ((Object)this.attributes).hashCode() ^ ((Object)this.children).hashCode();
    }

    private static final class QNameComparator
    implements Comparator<QName>,
    Serializable {
        private static final long serialVersionUID = -8711685004148549433L;

        private QNameComparator() {
        }

        @Override
        public int compare(QName name1, QName name2) {
            int uriComparator = name1.getNamespaceURI().compareTo(name2.getNamespaceURI());
            if (uriComparator != 0) {
                return uriComparator;
            }
            return name1.getLocalPart().compareTo(name2.getLocalPart());
        }
    }
}

