/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.EsbCallbackHandler;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityContext;
import org.jboss.soa.esb.services.security.SecurityService;
import org.jboss.soa.esb.services.security.SecurityServiceException;
import org.jboss.soa.esb.services.security.auth.AuthenticationRequest;
import org.jboss.soa.esb.services.security.principals.Role;
import org.jboss.soa.esb.util.ClassUtil;

public final class JaasSecurityService
implements SecurityService {
    private String callbackHandlerClassName;

    @Override
    public void authenticate(SecurityConfig config, SecurityContext securityContext, AuthenticationRequest authRequest) throws SecurityServiceException {
        AssertArgument.isNotNull(config, "config");
        try {
            EsbCallbackHandler callbackHandler = this.createCallbackHandler(config, authRequest);
            LoginContext loginContext = callbackHandler != null ? new LoginContext(config.getModuleName(), securityContext.getSubject(), callbackHandler) : new LoginContext(config.getModuleName(), securityContext.getSubject());
            loginContext.login();
            this.addRunAs(config.getRunAs(), securityContext.getSubject());
        }
        catch (LoginException e) {
            throw new SecurityServiceException("Exception while trying to login:", e);
        }
    }

    @Override
    public boolean checkRolesAllowed(List<String> rolesAllowed, SecurityContext securityContext) {
        if (rolesAllowed.isEmpty()) {
            return true;
        }
        for (String roleName : rolesAllowed) {
            boolean isInRole = securityContext.isCallerInRole(roleName);
            if (!isInRole) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isCallerInRole(Subject subject, Principal role) {
        Set<Group> principals = subject.getPrincipals(Group.class);
        for (Group group : principals) {
            if (!group.isMember(role)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void configure() throws ConfigurationException {
        this.callbackHandlerClassName = Configuration.getSecurityServiceCallbackHandlerImplClass();
    }

    @Override
    public void logout(SecurityConfig config) {
    }

    @Override
    public void refreshSecurityConfig() {
    }

    private EsbCallbackHandler createCallbackHandler(SecurityConfig config, AuthenticationRequest authRequest) throws SecurityServiceException {
        EsbCallbackHandler callbackHandler = null;
        String callbackImpl = config.getCallbackHandler();
        if (callbackImpl == null) {
            callbackImpl = this.callbackHandlerClassName;
        }
        if (callbackImpl != null) {
            callbackHandler = (EsbCallbackHandler)this.createNewInstance(callbackImpl);
            callbackHandler.setAuthenticationRequest(authRequest);
            callbackHandler.setSecurityConfig(config);
        }
        return callbackHandler;
    }

    private void addRunAs(String runAs, Subject subject) {
        if (runAs != null) {
            Role runAsRole = new Role(runAs);
            Set<org.jboss.soa.esb.services.security.principals.Group> principals = subject.getPrincipals(org.jboss.soa.esb.services.security.principals.Group.class);
            if (principals.isEmpty()) {
                org.jboss.soa.esb.services.security.principals.Group group = new org.jboss.soa.esb.services.security.principals.Group("Roles");
                group.addMember(runAsRole);
                subject.getPrincipals().add((Principal)((Object)group));
            } else {
                for (org.jboss.soa.esb.services.security.principals.Group groups : principals) {
                    if (!"Roles".equals(groups.getName())) continue;
                    groups.addMember(runAsRole);
                }
            }
        }
    }

    private <T extends EsbCallbackHandler> T createNewInstance(String className) throws SecurityServiceException {
        try {
            Class forName = ClassUtil.forName(className, this.getClass());
            return (T)((EsbCallbackHandler)forName.newInstance());
        }
        catch (ClassNotFoundException e) {
            throw new SecurityServiceException("ClassNotFoundException while trying to create an impl of [" + className + "]", e);
        }
        catch (InstantiationException e) {
            throw new SecurityServiceException("InstantiationException while trying to create an impl of [" + className + "]", e);
        }
        catch (IllegalAccessException e) {
            throw new SecurityServiceException("IllegalAccess while trying to create an impl of [" + className + "]", e);
        }
    }
}

