/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.services.security;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.services.security.SecurityContextPropagator;
import org.jboss.security.RunAs;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityAssociation;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.services.security.SecurityConfig;
import org.jboss.soa.esb.services.security.SecurityContext;
import org.jboss.soa.esb.services.security.principals.User;
import org.jboss.soa.esb.util.ClassUtil;

public final class JBossASContextPropagator
implements SecurityContextPropagator {
    private static final Logger LOGGER = Logger.getLogger(JBossASContextPropagator.class);
    private static final JBossASSecurityContextOperations OPERATIONS;

    @Override
    public void pushSecurityContext(SecurityContext context, Set<?> authCredentials, SecurityConfig config) {
        this.pushSecurityContext(context, authCredentials, config, OPERATIONS);
    }

    public void pushSecurityContext(SecurityContext context, Set<?> authCredentials, final SecurityConfig config, JBossASSecurityContextOperations operations) {
        AssertArgument.isNotNull(context, "context");
        final Subject subject = context.getSubject();
        final Principal principal = this.getPrincipal(subject);
        final Object credential = authCredentials != null && !authCredentials.isEmpty() ? authCredentials.iterator().next() : null;
        final JBossASSecurityContextOperations ops = this.getSecurityContextOperations(operations);
        final String domain = context.getDomain();
        if (System.getSecurityManager() == null) {
            ops.pushSecurityContext(principal, credential, subject, domain, config);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ops.pushSecurityContext(principal, credential, subject, domain, config);
                    return null;
                }
            });
        }
    }

    @Override
    public void popSecurityContext(SecurityContext context, SecurityConfig config) {
        this.popSecurityContext(context, config, OPERATIONS);
    }

    public void popSecurityContext(SecurityContext context, final SecurityConfig config, JBossASSecurityContextOperations operations) {
        final JBossASSecurityContextOperations ops = this.getSecurityContextOperations(operations);
        if (System.getSecurityManager() == null) {
            ops.popSecurityContext(config);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    ops.popSecurityContext(config);
                    return null;
                }
            });
        }
    }

    private JBossASSecurityContextOperations getSecurityContextOperations(JBossASSecurityContextOperations operations) {
        return operations != null ? operations : OPERATIONS;
    }

    private Principal getPrincipal(Subject subject) {
        Iterator<Principal> i$ = subject.getPrincipals().iterator();
        if (i$.hasNext()) {
            Principal principal = i$.next();
            return principal;
        }
        return new User("NullPrincipal");
    }

    private static boolean isSecurityContextAssociationPresent() {
        try {
            ClassUtil.forName("org.jboss.security.SecurityContextAssociation", JBossASContextPropagator.class);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Throwable th) {
            LOGGER.debug((Object)"Exception checking for SecurityContextAssociation", th);
        }
        return false;
    }

    static {
        JBossASSecurityContextOperations operations = null;
        String implementation = Configuration.getJBossASSecurityContextOperationsImplementationClass();
        if (implementation != null) {
            try {
                Class implementationClass = ClassUtil.forName(implementation, JBossASContextPropagator.class);
                operations = (JBossASSecurityContextOperations)implementationClass.newInstance();
            }
            catch (Throwable th) {
                LOGGER.error((Object)"Unexpected exception creating security context operations implementation, falling back to default", th);
            }
        }
        if (operations == null) {
            JBossASSecurityContextOperations jBossASSecurityContextOperations = operations = JBossASContextPropagator.isSecurityContextAssociationPresent() ? new AS5SecurityContextOperations() : new AS4SecurityContextOperations();
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Default JBossASSecurityContextOperations initialised to " + operations.getClass().getName()));
        }
        OPERATIONS = operations;
    }

    public static class AS5SecurityContextOperations
    implements JBossASSecurityContextOperations {
        @Override
        public void pushSecurityContext(Principal principal, Object credential, Subject subject, String domain, SecurityConfig securityConfig) {
            String securityDomain = domain == null ? "other" : domain;
            try {
                org.jboss.security.SecurityContext securityContext = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)credential, (Subject)subject, (String)securityDomain);
                SecurityContextAssociation.setSecurityContext((org.jboss.security.SecurityContext)securityContext);
                if (securityConfig != null && securityConfig.hasRunAs()) {
                    securityContext.setOutgoingRunAs((RunAs)new RunAsIdentity(securityConfig.getRunAs(), principal.getName()));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected exception creating security context", ex);
            }
        }

        @Override
        public void popSecurityContext(SecurityConfig securityConfig) {
            org.jboss.security.SecurityContext securityContext = SecurityContextAssociation.getSecurityContext();
            if (securityContext != null) {
                if (securityConfig != null && securityConfig.hasRunAs()) {
                    securityContext.setOutgoingRunAs(null);
                }
                SecurityContextAssociation.clearSecurityContext();
            }
        }
    }

    public static class AS4SecurityContextOperations
    implements JBossASSecurityContextOperations {
        @Override
        public void pushSecurityContext(Principal principal, Object credential, Subject subject, String domain, SecurityConfig securityConfig) {
            try {
                SecurityAssociation.pushSubjectContext((Subject)subject, (Principal)principal, (Object)credential);
                if (securityConfig != null && securityConfig.hasRunAs()) {
                    SecurityAssociation.pushRunAsIdentity((RunAsIdentity)new RunAsIdentity(securityConfig.getRunAs(), principal.getName()));
                }
            }
            catch (Exception ex) {
                throw new RuntimeException("Unexpected exception creating security context", ex);
            }
        }

        @Override
        public void popSecurityContext(SecurityConfig securityConfig) {
            if (securityConfig != null && securityConfig.hasRunAs()) {
                SecurityAssociation.popRunAsIdentity();
            }
            SecurityAssociation.popSubjectContext();
        }
    }

    public static interface JBossASSecurityContextOperations {
        public void pushSecurityContext(Principal var1, Object var2, Subject var3, String var4, SecurityConfig var5);

        public void popSecurityContext(SecurityConfig var1);
    }
}

