/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.rosetta.pooling;

import com.arjuna.common.util.propertyservice.PropertyManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.rosetta.pooling.ConnectionException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionFailureException;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsConnectionPoolContainer;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsSession;
import org.jboss.internal.soa.esb.rosetta.pooling.JmsXASession;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.common.TransactionStrategy;
import org.jboss.soa.esb.common.TransactionStrategyException;
import org.jboss.soa.esb.helpers.NamingContextException;
import org.jboss.soa.esb.helpers.NamingContextPool;
import org.jboss.soa.esb.util.JmsUtil;

public class JmsConnectionPool {
    private static final int DEFAULT_POOL_SIZE = 20;
    private static final int DEFAULT_SLEEP = 30;
    private static int CONFIGURED_POOL_SIZE = 20;
    private static int CONFIGURED_SLEEP = 30;
    private static final Executor SESSION_EXECUTOR = Executors.newSingleThreadExecutor(new DaemonThreadFactory());
    private static final CompletionService<JmsSession> COMPLETION_SERVICE = new ExecutorCompletionService<JmsSession>(SESSION_EXECUTOR);
    private int maxSessions = 20;
    private int maxSessionsPerConnection;
    private int maxXASessionsPerConnection;
    private int sleepTime = 30;
    private Map<String, String> poolKey;
    private Logger logger = Logger.getLogger(this.getClass());
    private List<JmsSessionPool> sessionPools = new ArrayList<JmsSessionPool>();
    private Boolean isXAAware;
    private boolean terminated;
    private long id;

    public JmsConnectionPool(Map<String, String> poolKey) throws ConnectionException {
        this(poolKey, CONFIGURED_POOL_SIZE, CONFIGURED_SLEEP);
    }

    public JmsConnectionPool(Map<String, String> poolKey, int poolSize, int sleepTime) throws ConnectionException {
        this.poolKey = poolKey;
        this.maxSessions = poolSize;
        this.sleepTime = sleepTime;
        this.maxSessionsPerConnection = this.getIntPoolConfig(poolKey, "max-sessions-per-connection", this.maxSessions);
        if (this.maxSessionsPerConnection < 1) {
            throw new ConnectionException("Invalid 'max-sessions-per-connection' configuration value '" + this.maxSessionsPerConnection + "'.  Must be greater than 0.");
        }
        this.maxXASessionsPerConnection = this.getIntPoolConfig(poolKey, "max-xa-sessions-per-connection", this.maxSessionsPerConnection);
        if (this.maxXASessionsPerConnection < 1) {
            throw new ConnectionException("Invalid 'max-xa-sessions-per-connection' configuration value '" + this.maxXASessionsPerConnection + "'.  Must be greater than 0.");
        }
        if (this.maxXASessionsPerConnection > this.maxSessionsPerConnection) {
            throw new ConnectionException("Invalid 'max-xa-sessions-per-connection' configuration value '" + this.maxXASessionsPerConnection + "'.  Cannot be greater than the configured value for '" + "max-sessions-per-connection" + "', which is " + this.maxSessionsPerConnection + ".");
        }
    }

    private int getIntPoolConfig(Map<String, String> poolKey, String configKey, int defaultVal) throws ConnectionException {
        String configValueString = poolKey.get(configKey);
        int configValue = defaultVal;
        if (configValueString != null) {
            try {
                configValue = Integer.parseInt(configValueString.trim());
            }
            catch (NumberFormatException e) {
                throw new ConnectionException("Invalid '" + configKey + "' configuration value '" + configValueString.trim() + "'.  Must be a valid Integer.");
            }
        }
        return configValue;
    }

    protected int getMaxSessions() {
        return this.maxSessions;
    }

    protected int getMaxSessionsPerConnection() {
        return this.maxSessionsPerConnection;
    }

    public int getMaxXASessionsPerConnection() {
        return this.maxXASessionsPerConnection;
    }

    protected List<JmsSessionPool> getSessionPools() {
        return this.sessionPools;
    }

    public synchronized JmsSession getSession(int acknowledgeMode) throws NamingException, JMSException, ConnectionException {
        if (this.terminated) {
            throw new ConnectionException("Connection pool has been terminated");
        }
        try {
            return this.internalGetSession(acknowledgeMode);
        }
        catch (JMSException jmse) {
            if (this.messagingConnectionFailure(jmse)) {
                return this.internalGetSession(acknowledgeMode);
            }
            throw jmse;
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized JmsSession internalGetSession(int acknowledgeMode) throws NamingException, JMSException, ConnectionException {
        if (this.sessionPools.isEmpty()) {
            this.addSessionPool();
        }
        if (this.isXAAware == null) {
            try {
                this.getFactoryConnection();
            }
            catch (NamingContextException nce) {
                throw new ConnectionException("Unexpected exception accessing Naming Context", nce);
            }
        }
        try {
            transacted = this.isXAAware != false && TransactionStrategy.getTransactionStrategy(true).isActive() != false;
        }
        catch (TransactionStrategyException tse) {
            throw new ConnectionException("Failed to determine current transaction context", tse);
        }
        if (transacted && (currentSession = this.getXASession()) != null) {
            return currentSession;
        }
        mode = transacted != false ? 0 : acknowledgeMode;
        end = System.currentTimeMillis() + (long)(this.sleepTime * 1000);
        emitExpiry = this.logger.isDebugEnabled();
        while (true) lbl-1000:
        // 4 sources

        {
            for (JmsSessionPool sessionPool : this.sessionPools) {
                try {
                    session = sessionPool.getSession(mode, transacted);
                    if (session == null) continue;
                    return session;
                }
                catch (JMSException jmse) {
                    if (this.messagingConnectionFailure(jmse)) {
                        sessionPool.cleanSessionPool();
                    }
                    throw jmse;
                }
            }
            if (this.getSessionsInPool() < this.maxSessions) {
                this.addSessionPool();
                ** continue;
            }
            if (emitExpiry) {
                this.logger.debug((Object)"The connection pool was exhausted, waiting for a session to be released.");
                emitExpiry = false;
            }
            if ((delay = end - (now = System.currentTimeMillis())) <= 0L) {
                throw new ConnectionException("Could not obtain a JMS connection from the pool after " + this.sleepTime + "s.");
            }
            try {
                this.wait(delay);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getFactoryConnection() throws NamingContextException, NamingException {
        String connectionFactoryString = this.poolKey.get("connection-factory");
        Object factoryConnection = null;
        Properties jndiEnvironment = JmsConnectionPoolContainer.getJndiEnvironment(this.poolKey);
        Context jndiContext = NamingContextPool.getNamingContext(jndiEnvironment);
        try {
            factoryConnection = jndiContext.lookup(connectionFactoryString);
        }
        catch (NamingException ne) {
            this.logger.info((Object)"Received NamingException, refreshing context.");
            jndiContext = NamingContextPool.replaceNamingContext(jndiContext, JmsConnectionPoolContainer.getJndiEnvironment(this.poolKey));
            factoryConnection = jndiContext.lookup(connectionFactoryString);
        }
        finally {
            NamingContextPool.releaseNamingContext(jndiContext);
        }
        this.isXAAware = factoryConnection instanceof XAConnectionFactory;
        return factoryConnection;
    }

    private JmsSessionPool addSessionPool() throws NamingException, JMSException, ConnectionException {
        JmsSessionPool sessionPool = new JmsSessionPool();
        this.sessionPools.add(sessionPool);
        return sessionPool;
    }

    public JmsSession getSession() throws NamingException, JMSException, ConnectionException {
        return this.getSession(1);
    }

    public void closeSession(Session session) {
        if (session instanceof JmsSession) {
            this.closeSession((JmsSession)session);
        } else {
            this.logger.error((Object)("Invalid JMS Session type in closeSession: " + session));
        }
    }

    public void closeSession(JmsSession session) {
        session.handleCloseSession(this);
    }

    synchronized void handleCloseSession(JmsSession session) {
        JmsSessionPool sessionPool = this.findOwnerPool(session);
        if (sessionPool != null) {
            sessionPool.handleCloseSession(session);
        }
    }

    synchronized void handleReleaseSession(JmsSession session) {
        session.releaseResources();
        try {
            session.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.releaseInUseSession(session);
    }

    void handleException(JmsSession jmsSession, JMSException jmse) throws JMSException {
        if (this.messagingConnectionFailure(jmse)) {
            JmsSessionPool sessionPool = this.findOwnerPool(jmsSession);
            if (sessionPool != null) {
                sessionPool.cleanSessionPool();
            }
            throw new JmsConnectionFailureException("The underlying exception appears to have failed", jmse);
        }
    }

    private boolean messagingConnectionFailure(JMSException jmse) {
        Throwable cause = jmse;
        while (cause.getCause() != null) {
            cause = cause.getCause();
        }
        return cause instanceof IllegalStateException;
    }

    private void releaseInUseSession(JmsSession session) {
        JmsSessionPool sessionPool = this.findOwnerPool(session);
        if (sessionPool != null) {
            sessionPool.releaseInUseSession(session);
        }
        this.notifyAll();
    }

    public synchronized void releaseSession(JmsSession session) {
        session.handleReleaseSession(this);
    }

    public synchronized void releaseSession(Session session) {
        if (session instanceof JmsSession) {
            this.releaseSession((JmsSession)session);
        } else {
            this.logger.error((Object)("Invalid JMS Session type in releaseSession: " + session));
        }
    }

    public synchronized void removeSessionPool() {
        for (JmsSessionPool sessionPool : this.sessionPools) {
            try {
                sessionPool.removeSessionPool();
            }
            catch (Exception e) {
                this.logger.error((Object)"Exception while removing JmsSessionPool.", (Throwable)e);
            }
        }
        this.sessionPools.clear();
        this.terminated = true;
        JmsConnectionPoolContainer.removePool(this.poolKey);
    }

    public int getSessionsInPool() {
        return this.getSessionsInPool(1) + this.getSessionsInPool(2) + this.getSessionsInPool(3) + this.getSessionsInPool(0);
    }

    public synchronized int getSessionsInPool(int acknowledgeMode) {
        return this.getFreeSessionsInPool(acknowledgeMode) + this.getInUseSessionsInPool(acknowledgeMode);
    }

    public synchronized int getFreeSessionsInPool(int acknowledgeMode) {
        int count = 0;
        for (JmsSessionPool sessionPool : this.sessionPools) {
            count += sessionPool.getFreeSessionsInPool(acknowledgeMode);
        }
        return count;
    }

    public synchronized int getInUseSessionsInPool(int acknowledgeMode) {
        int count = 0;
        for (JmsSessionPool sessionPool : this.sessionPools) {
            count += sessionPool.getInUseSessionsInPool(acknowledgeMode);
        }
        return count;
    }

    private Object getTransaction() throws ConnectionException {
        try {
            return TransactionStrategy.getTransactionStrategy(true).getTransaction();
        }
        catch (TransactionStrategyException tse) {
            throw new ConnectionException("Failed to determine current transaction context", tse);
        }
    }

    private synchronized JmsXASession getXASession() throws ConnectionException {
        Object tx = this.getTransaction();
        for (JmsSessionPool sessionPool : this.sessionPools) {
            JmsXASession session = (JmsXASession)sessionPool.transactionsToSessions.get(tx);
            if (session == null) continue;
            return session;
        }
        return null;
    }

    synchronized void associateTransaction(JmsXASession session) throws ConnectionException {
        JmsSessionPool sessionPool = this.findOwnerPool(session);
        if (sessionPool != null) {
            sessionPool.associateTransaction(session);
        }
    }

    synchronized void disassociateTransaction(JmsXASession session) {
        JmsSessionPool sessionPool = this.findOwnerPool(session);
        if (sessionPool != null) {
            sessionPool.disassociateTransaction(session);
        }
    }

    JmsSessionPool findOwnerPool(JmsSession session) {
        return session.getSessionPool();
    }

    static {
        PropertyManager prop = ModulePropertyManager.getPropertyManager("transports");
        String value = prop.getProperty("org.jboss.soa.esb.jms.connectionPool");
        if (value != null) {
            try {
                CONFIGURED_POOL_SIZE = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
        if ((value = prop.getProperty("org.jboss.soa.esb.jms.sessionSleep")) != null) {
            try {
                CONFIGURED_SLEEP = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();

        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = this.defaultFactory.newThread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }

    class JmsSessionPool {
        protected Connection jmsConnection;
        private Map<Integer, ArrayList<JmsSession>> freeSessionsMap = new HashMap<Integer, ArrayList<JmsSession>>();
        private Map<Integer, ArrayList<JmsSession>> inUseSessionsMap = new HashMap<Integer, ArrayList<JmsSession>>();
        private Map<Object, JmsXASession> transactionsToSessions = new HashMap<Object, JmsXASession>();
        private Map<JmsXASession, Object> sessionsToTransactions = new HashMap<JmsXASession, Object>();

        private JmsSessionPool() {
            this.freeSessionsMap.put(1, new ArrayList());
            this.freeSessionsMap.put(2, new ArrayList());
            this.freeSessionsMap.put(3, new ArrayList());
            this.inUseSessionsMap.put(1, new ArrayList());
            this.inUseSessionsMap.put(2, new ArrayList());
            this.inUseSessionsMap.put(3, new ArrayList());
        }

        public synchronized void removeSessionPool() {
            this.freeSessionsMap = null;
            this.inUseSessionsMap = null;
            this.transactionsToSessions = null;
            this.sessionsToTransactions = null;
            JmsConnectionPool.this.logger.debug((Object)"Emptied the session pool now closing the connection to the factory.");
            if (this.jmsConnection != null) {
                try {
                    this.jmsConnection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.jmsConnection = null;
            }
        }

        public synchronized JmsSession getSession(int acknowledgeMode, boolean transacted) throws ConnectionException, NamingException, JMSException {
            this.initConnection();
            ArrayList<JmsSession> freeSessions = this.freeSessionsMap.get(acknowledgeMode);
            ArrayList<JmsSession> inUseSessions = this.inUseSessionsMap.get(acknowledgeMode);
            if (freeSessions.size() > 0) {
                JmsSession session = freeSessions.remove(freeSessions.size() - 1);
                inUseSessions.add(session);
                return session;
            }
            if (this.getSessionsInPool() < JmsConnectionPool.this.maxSessionsPerConnection) {
                JmsSession session = null;
                if (transacted) {
                    if (this.getXASessionsInPool() < JmsConnectionPool.this.maxXASessionsPerConnection) {
                        session = this.addAnotherSession(JmsConnectionPool.this.poolKey, transacted, acknowledgeMode);
                    }
                } else {
                    session = this.addAnotherSession(JmsConnectionPool.this.poolKey, transacted, acknowledgeMode);
                }
                if (session != null) {
                    inUseSessions.add(session);
                    return session;
                }
            }
            return null;
        }

        private synchronized void initConnection() throws ConnectionException, NamingException, JMSException {
            if (JmsConnectionPool.this.terminated) {
                throw new ConnectionException("Connection pool has been terminated");
            }
            if (this.jmsConnection == null) {
                try {
                    JmsConnectionPool.this.logger.debug((Object)("Creating a JMS Connection for poolKey : " + JmsConnectionPool.this.poolKey));
                    Object factoryConnection = JmsConnectionPool.this.getFactoryConnection();
                    String username = (String)JmsConnectionPool.this.poolKey.get("jms-security-principal");
                    String password = (String)JmsConnectionPool.this.poolKey.get("jms-security-credential");
                    boolean useJMSSecurity = JmsUtil.isSecurityConfigured(username, password);
                    JmsConnectionPool.this.logger.debug((Object)("JMS Security principal [" + username + "] using JMS Security : " + useJMSSecurity));
                    if (useJMSSecurity) {
                        password = JmsUtil.getPasswordFromFile(password);
                    }
                    if (JmsConnectionPool.this.isXAAware.booleanValue()) {
                        XAConnectionFactory factory = (XAConnectionFactory)factoryConnection;
                        this.jmsConnection = useJMSSecurity ? factory.createXAConnection(username, password) : factory.createXAConnection();
                        this.freeSessionsMap.put(0, new ArrayList());
                        this.inUseSessionsMap.put(0, new ArrayList());
                    } else if (factoryConnection instanceof ConnectionFactory) {
                        ConnectionFactory factory = (ConnectionFactory)factoryConnection;
                        this.jmsConnection = useJMSSecurity ? factory.createConnection(username, password) : factory.createConnection();
                    } else {
                        throw new ConnectionException("Unknown factory connection type: " + factoryConnection.getClass().getCanonicalName());
                    }
                    this.jmsConnection.setExceptionListener(new ExceptionListener(){

                        public void onException(JMSException arg0) {
                            JmsSessionPool.this.cleanSessionPool();
                        }
                    });
                    this.jmsConnection.start();
                }
                catch (NamingContextException nce) {
                    throw new ConnectionException("Unexpected exception accessing Naming Context", nce);
                }
            }
        }

        private synchronized JmsSession addAnotherSession(Map<String, String> poolKey, final boolean transacted, final int acknowledgeMode) throws JMSException {
            block5: {
                final long currentID = JmsConnectionPool.this.id;
                final Connection currentConnection = this.jmsConnection;
                Future<JmsSession> future = COMPLETION_SERVICE.submit(new Callable<JmsSession>(){

                    @Override
                    public JmsSession call() throws JMSException {
                        JmsSession session = transacted ? new JmsXASession(JmsConnectionPool.this, JmsSessionPool.this, ((XAConnection)currentConnection).createXASession(), currentID, acknowledgeMode) : new JmsSession(JmsConnectionPool.this, JmsSessionPool.this, currentConnection.createSession(transacted, acknowledgeMode), currentID, acknowledgeMode);
                        return session;
                    }
                });
                try {
                    JmsSession session = future.get();
                    JmsConnectionPool.this.logger.debug((Object)("Number of Sessions in the pool with acknowledgeMode: " + acknowledgeMode + " is now " + this.getSessionsInPool(acknowledgeMode)));
                    return session;
                }
                catch (InterruptedException ie) {
                }
                catch (ExecutionException ee) {
                    Throwable th = ee.getCause();
                    if (th instanceof JMSException) {
                        throw (JMSException)th;
                    }
                    if (th instanceof Error) {
                        throw (Error)th;
                    }
                    if (!(th instanceof RuntimeException)) break block5;
                    throw (RuntimeException)th;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanSessionPool() {
            Connection connection;
            JmsSessionPool jmsSessionPool = this;
            synchronized (jmsSessionPool) {
                if (JmsConnectionPool.this.terminated) {
                    return;
                }
                JmsConnectionPool.this.id++;
                for (ArrayList<JmsSession> list : this.freeSessionsMap.values()) {
                    list.clear();
                }
                for (ArrayList<JmsSession> list : this.inUseSessionsMap.values()) {
                    list.clear();
                }
                this.transactionsToSessions.clear();
                this.sessionsToTransactions.clear();
                JmsConnectionPool.this.logger.debug((Object)"Cleared the session pool now closing the connection to the factory.");
                connection = this.jmsConnection;
                this.jmsConnection = null;
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private synchronized int getSessionsInPool() {
            return this.getSessionsInPool(JmsSession.class);
        }

        private synchronized int getXASessionsInPool() {
            return this.getSessionsInPool(JmsXASession.class);
        }

        private synchronized int getSessionsInPool(Class<? extends JmsSession> jmsSessionType) {
            int total = 0;
            total += this.getSessionsInMap(this.freeSessionsMap, jmsSessionType);
            return total += this.getSessionsInMap(this.inUseSessionsMap, jmsSessionType);
        }

        private synchronized int getSessionsInMap(Map<Integer, ArrayList<JmsSession>> sessionsMap, Class<? extends JmsSession> jmsSessionType) {
            Collection<ArrayList<JmsSession>> sessionLists = sessionsMap.values();
            int total = 0;
            for (ArrayList<JmsSession> sessionList : sessionLists) {
                for (JmsSession session : sessionList) {
                    if (!jmsSessionType.isAssignableFrom(session.getClass())) continue;
                    ++total;
                }
            }
            return total;
        }

        public synchronized int getSessionsInPool(int acknowledgeMode) {
            return this.getFreeSessionsInPool(acknowledgeMode) + this.getInUseSessionsInPool(acknowledgeMode);
        }

        public synchronized int getFreeSessionsInPool(int acknowledgeMode) {
            ArrayList<JmsSession> freeSessionMap = this.freeSessionsMap == null ? null : this.freeSessionsMap.get(acknowledgeMode);
            int numFreeSessions = freeSessionMap == null ? 0 : freeSessionMap.size();
            return numFreeSessions;
        }

        public synchronized int getInUseSessionsInPool(int acknowledgeMode) {
            ArrayList<JmsSession> inUseSessionMap = this.inUseSessionsMap == null ? null : this.inUseSessionsMap.get(acknowledgeMode);
            int numInUseSessions = inUseSessionMap == null ? 0 : inUseSessionMap.size();
            return numInUseSessions;
        }

        synchronized void associateTransaction(JmsXASession session) throws ConnectionException {
            Object tx = JmsConnectionPool.this.getTransaction();
            if (tx == null) {
                throw new ConnectionException("No active transaction");
            }
            this.transactionsToSessions.put(tx, session);
            this.sessionsToTransactions.put(session, tx);
        }

        synchronized void disassociateTransaction(JmsXASession session) {
            Object tx = this.sessionsToTransactions.remove(session);
            this.transactionsToSessions.remove(tx);
        }

        public void releaseInUseSession(JmsSession session) {
            ArrayList<JmsSession> sessions;
            int mode = session.getRequestedAcknowledgeMode();
            ArrayList<JmsSession> arrayList = sessions = this.inUseSessionsMap == null ? null : this.inUseSessionsMap.get(mode);
            if (sessions != null) {
                sessions.remove(session);
            }
        }

        public void handleCloseSession(JmsSession session) {
            if (session.isSuspect()) {
                JmsConnectionPool.this.logger.debug((Object)"Session is suspect, dropping");
                JmsConnectionPool.this.handleReleaseSession(session);
            } else {
                if (session.getId() != JmsConnectionPool.this.id) {
                    JmsConnectionPool.this.logger.debug((Object)"Session is from a previous incarnation, dropping");
                } else {
                    ArrayList<JmsSession> sessions;
                    int mode = session.getRequestedAcknowledgeMode();
                    ArrayList<JmsSession> arrayList = sessions = this.freeSessionsMap == null ? null : this.freeSessionsMap.get(mode);
                    if (sessions != null) {
                        sessions.add(session);
                    }
                }
                session.releaseResources();
                this.releaseInUseSession(session);
            }
        }
    }
}

