/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.registry.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.juddi.v3.client.config.UDDIClerkManager;
import org.apache.juddi.v3.client.config.UDDIClientContainer;
import org.apache.juddi.v3.client.config.UDDINode;
import org.apache.juddi.v3.client.transport.Transport;
import org.apache.juddi.v3.client.transport.TransportException;
import org.apache.juddi.v3_service.JUDDIApiPortType;
import org.apache.log4j.Logger;
import org.uddi.v3_service.UDDICustodyTransferPortType;
import org.uddi.v3_service.UDDIInquiryPortType;
import org.uddi.v3_service.UDDIPublicationPortType;
import org.uddi.v3_service.UDDISecurityPortType;
import org.uddi.v3_service.UDDISubscriptionListenerPortType;
import org.uddi.v3_service.UDDISubscriptionPortType;

public class JuddiRMITransport
extends Transport {
    private static final Logger logger = Logger.getLogger(JuddiRMITransport.class);
    private final String managerName;
    private final String nodeName;
    private final Properties jndiEnv;
    private final AtomicReference<JUDDIApiPortType> apiService = new AtomicReference();
    private final AtomicReference<UDDICustodyTransferPortType> custodyTransferService = new AtomicReference();
    private final AtomicReference<UDDIInquiryPortType> inquiryService = new AtomicReference();
    private final AtomicReference<UDDIPublicationPortType> publishService = new AtomicReference();
    private final AtomicReference<UDDISecurityPortType> securityService = new AtomicReference();
    private final AtomicReference<UDDISubscriptionListenerPortType> subscriptionListenerService = new AtomicReference();
    private final AtomicReference<UDDISubscriptionPortType> subscriptionService = new AtomicReference();

    public JuddiRMITransport() throws ConfigurationException {
        this(null);
    }

    public JuddiRMITransport(String nodeName) throws ConfigurationException {
        this(null, nodeName);
    }

    public JuddiRMITransport(String managerName, String nodeName) throws ConfigurationException {
        this.managerName = managerName;
        this.nodeName = nodeName == null ? "default" : nodeName;
        this.jndiEnv = JuddiRMITransport.createEnvironment(managerName, nodeName);
    }

    public JUDDIApiPortType getJUDDIApiService(String endpointURL) throws TransportException {
        JUDDIApiPortType currentApiService = this.apiService.get();
        if (currentApiService != null) {
            return currentApiService;
        }
        String apiURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getJuddiApiUrl();
        JUDDIApiPortType newApiService = (JUDDIApiPortType)JuddiRMITransport.lookupService(this.jndiEnv, apiURL);
        if (this.apiService.compareAndSet(null, newApiService)) {
            return newApiService;
        }
        return this.apiService.get();
    }

    public UDDICustodyTransferPortType getUDDICustodyTransferService(String endpointURL) throws TransportException {
        UDDICustodyTransferPortType currentCustodyTransferService = this.custodyTransferService.get();
        if (currentCustodyTransferService != null) {
            return currentCustodyTransferService;
        }
        String custodyTransferURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getCustodyTransferUrl();
        UDDICustodyTransferPortType newCustodyTransferService = (UDDICustodyTransferPortType)JuddiRMITransport.lookupService(this.jndiEnv, custodyTransferURL);
        if (this.custodyTransferService.compareAndSet(null, newCustodyTransferService)) {
            return newCustodyTransferService;
        }
        return this.custodyTransferService.get();
    }

    public UDDIInquiryPortType getUDDIInquiryService(String endpointURL) throws TransportException {
        UDDIInquiryPortType currentInquiryService = this.inquiryService.get();
        if (currentInquiryService != null) {
            return currentInquiryService;
        }
        String inquiryURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getInquiryUrl();
        UDDIInquiryPortType newInquiryService = (UDDIInquiryPortType)JuddiRMITransport.lookupService(this.jndiEnv, inquiryURL);
        if (this.inquiryService.compareAndSet(null, newInquiryService)) {
            return newInquiryService;
        }
        return this.inquiryService.get();
    }

    public UDDIPublicationPortType getUDDIPublishService(String endpointURL) throws TransportException {
        UDDIPublicationPortType currentPublishService = this.publishService.get();
        if (currentPublishService != null) {
            return currentPublishService;
        }
        String publishURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getPublishUrl();
        UDDIPublicationPortType newPublishService = (UDDIPublicationPortType)JuddiRMITransport.lookupService(this.jndiEnv, publishURL);
        if (this.publishService.compareAndSet(null, newPublishService)) {
            return newPublishService;
        }
        return this.publishService.get();
    }

    public UDDISecurityPortType getUDDISecurityService(String endpointURL) throws TransportException {
        UDDISecurityPortType currentSecurityService = this.securityService.get();
        if (currentSecurityService != null) {
            return currentSecurityService;
        }
        String securityURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getSecurityUrl();
        UDDISecurityPortType newSecurityService = (UDDISecurityPortType)JuddiRMITransport.lookupService(this.jndiEnv, securityURL);
        if (this.securityService.compareAndSet(null, newSecurityService)) {
            return newSecurityService;
        }
        return this.securityService.get();
    }

    public UDDISubscriptionListenerPortType getUDDISubscriptionListenerService(String endpointURL) throws TransportException {
        UDDISubscriptionListenerPortType currentSubscriptionListenerService = this.subscriptionListenerService.get();
        if (currentSubscriptionListenerService != null) {
            return currentSubscriptionListenerService;
        }
        String subscriptionListenerURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getSubscriptionListenerUrl();
        UDDISubscriptionListenerPortType newSubscriptionListenerService = (UDDISubscriptionListenerPortType)JuddiRMITransport.lookupService(this.jndiEnv, subscriptionListenerURL);
        if (this.subscriptionListenerService.compareAndSet(null, newSubscriptionListenerService)) {
            return newSubscriptionListenerService;
        }
        return this.subscriptionListenerService.get();
    }

    public UDDISubscriptionPortType getUDDISubscriptionService(String endpointURL) throws TransportException {
        UDDISubscriptionPortType currentSubscriptionService = this.subscriptionService.get();
        if (currentSubscriptionService != null) {
            return currentSubscriptionService;
        }
        String subscriptionURL = JuddiRMITransport.getUDDINode(this.managerName, this.nodeName).getSubscriptionUrl();
        UDDISubscriptionPortType newSubscriptionService = (UDDISubscriptionPortType)JuddiRMITransport.lookupService(this.jndiEnv, subscriptionURL);
        if (this.subscriptionService.compareAndSet(null, newSubscriptionService)) {
            return newSubscriptionService;
        }
        return this.subscriptionService.get();
    }

    private static Properties createEnvironment(String managerName, String nodeName) throws ConfigurationException {
        Properties jndiEnv = new Properties();
        UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager((String)managerName);
        UDDINode uddiNode = manager.getClientConfig().getUDDINode(nodeName);
        String initialContextFactory = uddiNode.getFactoryInitial();
        String providerURL = uddiNode.getFactoryNamingProvider();
        String urlPkgPrefixes = uddiNode.getFactoryURLPkgs();
        if (initialContextFactory != null) {
            jndiEnv.setProperty("java.naming.factory.initial", initialContextFactory);
        }
        if (providerURL != null) {
            jndiEnv.setProperty("java.naming.provider.url", providerURL);
        }
        if (urlPkgPrefixes != null) {
            jndiEnv.setProperty("java.naming.factory.url.pkgs", urlPkgPrefixes);
        }
        return jndiEnv;
    }

    private static <T> T lookupService(Properties env, String url) throws TransportException {
        Object service;
        URI uri;
        try {
            uri = new URI(url);
        }
        catch (URISyntaxException urise) {
            throw new TransportException("Failed to parse service URL", (Throwable)urise);
        }
        String serviceLocation = uri.getPath();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Looking up service=" + serviceLocation));
        }
        try {
            InitialContext context = new InitialContext(env);
            service = context.lookup(serviceLocation);
        }
        catch (NamingException ne) {
            throw new TransportException("Failure during JNDI lookup of service: " + serviceLocation, (Throwable)ne);
        }
        return (T)service;
    }

    private static UDDINode getUDDINode(String managerName, String nodeName) throws TransportException {
        try {
            UDDIClerkManager manager = UDDIClientContainer.getUDDIClerkManager((String)managerName);
            return manager.getClientConfig().getUDDINode(nodeName);
        }
        catch (ConfigurationException ce) {
            throw new TransportException("Failed to retrieve UDDI node: " + nodeName, (Throwable)ce);
        }
    }
}

