/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.publish;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jboss.internal.soa.esb.assertion.AssertArgument;
import org.jboss.internal.soa.esb.publish.ContractProvider;
import org.jboss.soa.esb.lifecycle.LifecycleResource;
import org.jboss.soa.esb.lifecycle.LifecycleResourceException;
import org.jboss.soa.esb.lifecycle.LifecycleResourceFactory;
import org.jboss.soa.esb.lifecycle.LifecycleResourceManager;

public class ContractProviderLifecycleResource {
    private static final Logger logger = Logger.getLogger(ContractProviderLifecycleResource.class);
    private static final LifecycleResource<Map<String, ContractProvider>> lifecycleContractProviders = new LifecycleResource<Map<String, ContractProvider>>(new LifecycleContractProviderFactory(), 25000);

    private ContractProviderLifecycleResource() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putContractProvider(String serviceCategory, String serviceName, ContractProvider contractProvider) throws LifecycleResourceException {
        Map<String, ContractProvider> map;
        AssertArgument.isNotNull(contractProvider, "contractProvider");
        String key = ContractProviderLifecycleResource.buildKey(serviceCategory, serviceName);
        Map<String, ContractProvider> map2 = map = lifecycleContractProviders.getLifecycleResource();
        synchronized (map2) {
            map.put(key, contractProvider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContractProvider getContractProvider(String serviceCategory, String serviceName) throws LifecycleResourceException {
        Map<String, ContractProvider> map;
        String key = ContractProviderLifecycleResource.buildKey(serviceCategory, serviceName);
        Map<String, ContractProvider> map2 = map = lifecycleContractProviders.getLifecycleResource();
        synchronized (map2) {
            return map.get(key);
        }
    }

    private static String buildKey(String serviceCategory, String serviceName) {
        AssertArgument.isNotNullAndNotEmpty(serviceCategory, "serviceCategory");
        AssertArgument.isNotNullAndNotEmpty(serviceName, "serviceName");
        StringBuilder sb = new StringBuilder();
        sb.append(ContractProvider.class.getSimpleName());
        sb.append("?deployment=");
        sb.append(LifecycleResourceManager.getSingleton().getIdentity());
        sb.append('&');
        sb.append("service-category");
        sb.append('=');
        sb.append(serviceCategory);
        sb.append('&');
        sb.append("service-name");
        sb.append('=');
        sb.append(serviceName);
        return sb.toString();
    }

    private static class LifecycleContractProviderFactory
    implements LifecycleResourceFactory<Map<String, ContractProvider>> {
        private LifecycleContractProviderFactory() {
        }

        @Override
        public Map<String, ContractProvider> createLifecycleResource(String lifecycleIdentity) throws LifecycleResourceException {
            return new HashMap<String, ContractProvider>();
        }

        @Override
        public void destroyLifecycleResource(Map<String, ContractProvider> resource, String lifecycleIdentity) throws LifecycleResourceException {
            if (resource.size() > 0) {
                if (logger.isInfoEnabled()) {
                    for (String key : resource.keySet()) {
                        logger.info((Object)("Removing " + key));
                    }
                }
                resource.clear();
            }
        }
    }
}

