/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.publish;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.internal.soa.esb.publish.ContractReferencePublisher;
import org.jboss.soa.esb.Service;

public abstract class AbstractContractReferencePublisher
implements ContractReferencePublisher {
    private final Service service;
    private final String description;

    public AbstractContractReferencePublisher(Service service, String description) {
        this.service = service;
        this.description = description;
    }

    @Override
    public final Service getService() {
        return this.service;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final URI getServiceURI() {
        String endpointAddress = this.getEndpointAddress();
        if (endpointAddress != null) {
            try {
                return new URI(endpointAddress);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public final URI getServiceContractURI() {
        String endpointAddress = this.getEndpointAddress();
        if (endpointAddress != null) {
            try {
                return new URI(endpointAddress + "?wsdl");
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    public abstract String getEndpointAddress();
}

