/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.persistence.manager;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.persistence.manager.ConnectionManager;
import org.jboss.soa.esb.services.security.PasswordUtil;

public class StandaloneConnectionManager
implements ConnectionManager {
    private static StandaloneConnectionManager instance = null;
    protected ComboPooledDataSource pooledDS = null;
    private static Logger _logger = Logger.getLogger(StandaloneConnectionManager.class);

    @Override
    public synchronized ConnectionManager getInstance() {
        if (null != instance) {
            return instance;
        }
        try {
            instance = new StandaloneConnectionManager();
            instance.init();
        }
        catch (Exception e) {
            _logger.error((Object)"Could not initialise instance.", (Throwable)e);
            return null;
        }
        return instance;
    }

    @Override
    public void init() throws ConfigurationException {
        _logger.info((Object)"initializing...");
        this.pooledDS = new ComboPooledDataSource();
        try {
            this.pooledDS.setDriverClass(Configuration.getStoreDriver());
            this.pooledDS.setJdbcUrl(Configuration.getStoreUrl());
            this.pooledDS.setUser(Configuration.getStoreUser());
            String password = Configuration.getStorePwd();
            if (PasswordUtil.isPasswordFile(password)) {
                password = new PasswordUtil(password).getPasswordAsString();
            }
            this.pooledDS.setPassword(password);
            this.pooledDS.setMinPoolSize(Integer.valueOf(Configuration.getStorePoolMinSize()).intValue());
            this.pooledDS.setInitialPoolSize(Integer.valueOf(Configuration.getStorePoolInitialSize()).intValue());
            this.pooledDS.setMaxPoolSize(Integer.valueOf(Configuration.getStorePoolMaxSize()).intValue());
            this.pooledDS.setAutomaticTestTable(Configuration.getStorePoolTestTable());
            this.pooledDS.setCheckoutTimeout(Integer.valueOf(Configuration.getStorePoolTimeoutMillis()).intValue());
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        Connection conn = null;
        while (true) {
            if (null != this.pooledDS) {
                conn = this.pooledDS.getConnection();
                if (null != conn) break;
                _logger.error((Object)"Null pooledDS");
            }
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
        }
        return conn;
    }
}

