/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.persistence.manager;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.common.Configuration;
import org.jboss.soa.esb.persistence.manager.ConnectionManager;

public class J2eeConnectionManager
implements ConnectionManager {
    private static J2eeConnectionManager instance;
    private DataSource datasource = null;
    private Context oJndiCtx = null;
    private static Logger _logger;

    @Override
    public Connection getConnection() throws SQLException {
        return this.datasource.getConnection();
    }

    @Override
    public synchronized ConnectionManager getInstance() {
        if (null != instance) {
            return instance;
        }
        try {
            instance = new J2eeConnectionManager();
            instance.init();
        }
        catch (Exception e) {
            _logger.error((Object)"Could not initialise instance.", (Throwable)e);
            return null;
        }
        return instance;
    }

    @Override
    public void init() throws ConfigurationException {
        _logger.info((Object)"initializing...");
        try {
            this.oJndiCtx = new InitialContext();
            if (null == this.oJndiCtx) {
                _logger.error((Object)"could not get a valid context");
                throw new ConfigurationException("could not get a valid context - check your settings in the config file");
            }
            String dataSourcename = Configuration.getStoreDBDatasourceName();
            this.datasource = (DataSource)this.oJndiCtx.lookup(dataSourcename);
        }
        catch (Exception ex) {
            throw new ConfigurationException(ex);
        }
    }

    static {
        _logger = Logger.getLogger(J2eeConnectionManager.class);
    }
}

