/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml.marshal;

import java.net.URI;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalUnmarshalPlugin;
import org.jboss.internal.soa.esb.message.format.xml.marshal.MarshalValueImpl;
import org.jboss.internal.soa.esb.message.format.xml.marshal.SerializedMarshalUnmarshalPlugin;
import org.jboss.internal.soa.esb.util.stax.ElementContent;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.internal.soa.esb.util.stax.URIElement;
import org.jboss.soa.esb.MarshalException;
import org.jboss.soa.esb.common.ModulePropertyManager;
import org.jboss.soa.esb.util.ClassUtil;

public class MarshalUnmarshalManager {
    private Hashtable<URI, MarshalUnmarshalPlugin> _plugins = new Hashtable();
    private static final MarshalUnmarshalManager _instance = new MarshalUnmarshalManager();

    public static MarshalUnmarshalManager getInstance() {
        return _instance;
    }

    private MarshalUnmarshalManager() {
        Properties properties = ModulePropertyManager.getPropertyManager("core").getProperties();
        if (properties != null) {
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String attrName = (String)names.nextElement();
                if (!attrName.startsWith("org.jboss.soa.esb.message.format.xml.plugin")) continue;
                try {
                    String pluginName = properties.getProperty(attrName);
                    Class c = ClassUtil.forName(pluginName, this.getClass());
                    MarshalUnmarshalPlugin thePlugin = (MarshalUnmarshalPlugin)c.newInstance();
                    this._plugins.put(thePlugin.type(), thePlugin);
                }
                catch (ClassNotFoundException ex) {
                    ex.printStackTrace();
                }
                catch (IllegalAccessException ex) {
                    ex.printStackTrace();
                }
                catch (InstantiationException ex) {
                    ex.printStackTrace();
                }
            }
            SerializedMarshalUnmarshalPlugin defaultPlugin = new SerializedMarshalUnmarshalPlugin();
            this._plugins.put(defaultPlugin.type(), defaultPlugin);
        }
    }

    public boolean marshal(XMLStreamWriter out, MarshalValueImpl param) throws XMLStreamException {
        if (out == null || param == null) {
            throw new IllegalArgumentException();
        }
        String serialisedForm = param.getMarshalledForm();
        if (serialisedForm != null) {
            MarshalImpl marshal = new MarshalImpl(param.getMarshalledType(), serialisedForm);
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT_MARSHAL, marshal);
            return true;
        }
        Object obj = param.getValue();
        for (Map.Entry<URI, MarshalUnmarshalPlugin> entry : this._plugins.entrySet()) {
            String value;
            MarshalUnmarshalPlugin plugin = entry.getValue();
            if (!plugin.canPack(obj)) continue;
            try {
                value = plugin.marshal(obj);
            }
            catch (MarshalException me) {
                throw new XMLStreamException(me);
            }
            param.setMarshalledForm(value);
            param.setMarshalledType(plugin.type());
            MarshalImpl marshal = new MarshalImpl(entry.getKey(), value);
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT_MARSHAL, marshal);
            return true;
        }
        return false;
    }

    public MarshalValueImpl unmarshal(XMLStreamReader in) throws XMLStreamException {
        StreamHelper.checkNextStartTag(in, XMLUtil.ESB_QNAME_BODY_CONTENT_MARSHAL);
        MarshalImpl marshal = new MarshalImpl(in);
        StreamHelper.checkEndTag(in, XMLUtil.ESB_QNAME_BODY_CONTENT_MARSHAL);
        MarshalUnmarshalPlugin plugin = this._plugins.get(marshal.getType());
        if (plugin == null) {
            throw new XMLStreamException("Unrecognised marshal type: " + marshal.getType());
        }
        return new MarshalValueImpl(marshal.getType(), marshal.getContent());
    }

    MarshalUnmarshalPlugin getPlugin(URI type) {
        return this._plugins.get(type);
    }

    private static class MarshalImpl
    extends ElementContent {
        private URI type;
        private String content;

        MarshalImpl(URI type, String content) {
            this.type = type;
            this.content = content;
        }

        MarshalImpl(XMLStreamReader in) throws XMLStreamException {
            super.parse(in);
        }

        URI getType() {
            return this.type;
        }

        String getContent() {
            return this.content;
        }

        @Override
        protected void putElement(XMLStreamReader in, QName elementName) throws XMLStreamException {
            if (!XMLUtil.ESB_QNAME_BODY_CONTENT_MARSHAL_TYPE.equals(elementName)) {
                throw new XMLStreamException("Unrecognised element: " + elementName);
            }
            URIElement typeURI = new URIElement(in);
            this.type = typeURI.getValue();
        }

        @Override
        protected void putValue(XMLStreamReader in, String value) throws XMLStreamException {
            this.content = value;
        }

        @Override
        protected void writeChildContent(XMLStreamWriter out) throws XMLStreamException {
            URIElement typeURI = new URIElement(this.type);
            StreamHelper.writeElement(out, XMLUtil.ESB_QNAME_BODY_CONTENT_MARSHAL_TYPE, typeURI);
            out.writeCharacters(this.content);
        }
    }
}

