/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.internal.soa.esb.message.format.MessageSerializer;
import org.jboss.internal.soa.esb.message.format.xml.MessageImpl;
import org.jboss.internal.soa.esb.message.format.xml.XMLUtil;
import org.jboss.internal.soa.esb.util.XMLHelper;
import org.jboss.internal.soa.esb.util.stax.StreamHelper;
import org.jboss.soa.esb.message.Message;

public class XMLMessageSerializer
extends MessageSerializer {
    @Override
    public void serialize(Message message, OutputStream outStream) throws IOException {
        XMLStreamWriter streamWriter;
        this.assertMessageInstanceOK(message);
        outStream.write(0);
        try {
            streamWriter = XMLHelper.getXMLStreamWriter(outStream);
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException("Unable to create XMLStreamWriter instance.").initCause(e);
        }
        try {
            String origURI = StreamHelper.writeStartElement(streamWriter, XMLUtil.ESB_QNAME_ENVELOPE);
            ((MessageImpl)message).writeContent(streamWriter);
            StreamHelper.writeEndElement(streamWriter, XMLUtil.ESB_QNAME_ENVELOPE.getPrefix(), origURI);
            streamWriter.flush();
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException("Error writing message to output stream.").initCause(e);
        }
        finally {
            try {
                streamWriter.close();
            }
            catch (XMLStreamException e) {
                throw (IOException)new IOException("Error closing XMLStreamWriter instance.").initCause(e);
            }
        }
    }

    @Override
    public Message deserialize(InputStream inStream) throws IOException {
        XMLStreamReader streamReader;
        if (inStream.read() != 0) {
            throw new IOException("Cannot deserialize message.  Unrecognized message preamble.");
        }
        try {
            streamReader = XMLHelper.getXMLStreamReader(new InputStreamReader(inStream));
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException("Unable to create XMLStreamReader instance.").initCause(e);
        }
        try {
            StreamHelper.checkNextStartTag(streamReader, XMLUtil.ESB_QNAME_ENVELOPE);
            MessageImpl e = new MessageImpl(streamReader);
            return e;
        }
        catch (XMLStreamException e) {
            throw (IOException)new IOException("Error reading message to from stream.").initCause(e);
        }
        finally {
            try {
                streamReader.close();
            }
            catch (XMLStreamException e) {
                throw (IOException)new IOException("Error closing XMLStreamReader instance.").initCause(e);
            }
        }
    }

    private void assertMessageInstanceOK(Message message) throws IOException {
        if (!XMLMessageSerializer.isXMLMessage(message)) {
            throw new IOException("Invalid Message instance.  Expecting instance of '" + MessageImpl.class.getName() + "'.");
        }
    }

    public static boolean isXMLMessage(Message message) {
        return message instanceof MessageImpl;
    }
}

