/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.internal.soa.esb.message.format.xml;

import java.io.IOException;
import java.io.Serializable;
import org.jboss.internal.soa.esb.message.format.DeferredDeserialisationException;
import org.jboss.internal.soa.esb.util.Encoding;

public class SerializedValueImpl {
    private Serializable value;
    private String serialisedForm;

    public SerializedValueImpl(Serializable value) {
        this.value = value;
    }

    public SerializedValueImpl(String serialisedForm) {
        this.serialisedForm = serialisedForm;
    }

    public Serializable getValue() {
        if (this.value == null && this.serialisedForm != null) {
            try {
                this.value = Encoding.decodeToObject(this.serialisedForm);
            }
            catch (IOException ioe) {
                throw new DeferredDeserialisationException("Error reading object input stream", ioe);
            }
            catch (ClassNotFoundException cnfe) {
                throw new DeferredDeserialisationException("Error constructing object value", cnfe);
            }
        }
        this.serialisedForm = null;
        return this.value;
    }

    public String getSerialisedForm() {
        if (this.serialisedForm == null && this.value != null) {
            try {
                this.serialisedForm = Encoding.encodeObject(this.value);
            }
            catch (IOException ioe) {
                throw new DeferredDeserialisationException("Error writing object input stream", ioe);
            }
        }
        return this.serialisedForm;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "Deferred serialized value: " + Integer.toHexString(System.identityHashCode(this));
    }
}

